/*
 * Decompiled with CFR 0.152.
 */
package robust.gradle.plugin.javaassist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarOutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import robust.gradle.plugin.InsertcodeStrategy;

public class JavaAssistInsertImpl
extends InsertcodeStrategy {
    private boolean isCallMethod = false;

    public JavaAssistInsertImpl(List<String> hotfixPackageList, List<String> hotfixMethodList, List<String> exceptPackageList, List<String> exceptMethodList, boolean isHotfixMethodLevel, boolean isExceptMethodLevel, boolean isForceInsertLambda) {
        super(hotfixPackageList, hotfixMethodList, exceptPackageList, exceptMethodList, isHotfixMethodLevel, isExceptMethodLevel, isForceInsertLambda);
    }

    @Override
    protected void insertCode(List<CtClass> box, File jarFile) throws CannotCompileException, IOException, NotFoundException {
        JarOutputStream outStream = new JarOutputStream(new FileOutputStream(jarFile));
        for (CtClass ctClass : box) {
            if (this.isNeedInsertClass(ctClass.getName())) {
                ctClass.setModifiers(AccessFlag.setPublic((int)ctClass.getModifiers()));
                if (ctClass.isInterface() || ctClass.getDeclaredMethods().length < 1) {
                    this.zipFile(ctClass.toBytecode(), outStream, ctClass.getName().replaceAll("\\.", "/") + ".class");
                    continue;
                }
                boolean addIncrementalChange = false;
                for (CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {
                    if (!addIncrementalChange) {
                        addIncrementalChange = true;
                        ClassPool classPool = ctBehavior.getDeclaringClass().getClassPool();
                        CtClass type = classPool.getOrNull("com.meituan.robust.ChangeQuickRedirect");
                        CtField ctField = new CtField(type, "changeQuickRedirect", ctClass);
                        ctField.setModifiers(9);
                        ctClass.addField(ctField);
                    }
                    if (!this.isQualifiedMethod(ctBehavior)) continue;
                    this.methodMap.put(ctBehavior.getLongName(), this.insertMethodCount.incrementAndGet());
                    try {
                        if (!ctBehavior.getMethodInfo().isMethod()) continue;
                        CtMethod ctMethod = (CtMethod)ctBehavior;
                        boolean isStatic = (ctMethod.getModifiers() & 8) != 0;
                        CtClass returnType = ctMethod.getReturnType();
                        String returnTypeString = returnType.getName();
                        String body = "Object argThis = null;";
                        if (!isStatic) {
                            body = body + "argThis = $0;";
                        }
                        String parametersClassType = this.getParametersClassType(ctMethod);
                        body = body + "   if (com.meituan.robust.PatchProxy.isSupport($args, argThis, changeQuickRedirect, " + isStatic + ", " + this.methodMap.get(ctBehavior.getLongName()) + "," + parametersClassType + "," + returnTypeString + ".class)) {";
                        body = body + this.getReturnStatement(returnTypeString, isStatic, (Integer)this.methodMap.get(ctBehavior.getLongName()), parametersClassType, returnTypeString + ".class");
                        body = body + "   }";
                        ctBehavior.insertBefore(body);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.out.println("ctClass: " + ctClass.getName() + " error: " + t.getMessage());
                    }
                }
            }
            this.zipFile(ctClass.toBytecode(), outStream, ctClass.getName().replaceAll("\\.", "/") + ".class");
        }
        outStream.close();
    }

    private boolean isQualifiedMethod(CtBehavior it) throws CannotCompileException {
        if (it.getMethodInfo().isStaticInitializer()) {
            return false;
        }
        if (!this.isForceInsertLambda && (it.getModifiers() & 0x1000) != 0 && !AccessFlag.isPrivate((int)it.getModifiers())) {
            return false;
        }
        if (it.getMethodInfo().isConstructor()) {
            return false;
        }
        if ((it.getModifiers() & 0x400) != 0) {
            return false;
        }
        if ((it.getModifiers() & 0x100) != 0) {
            return false;
        }
        if ((it.getModifiers() & 0x200) != 0) {
            return false;
        }
        if (it.getMethodInfo().isMethod()) {
            boolean flag;
            if (AccessFlag.isPackage((int)it.getModifiers())) {
                it.setModifiers(AccessFlag.setPublic((int)it.getModifiers()));
            }
            if (!(flag = this.isMethodWithExpression((CtMethod)it))) {
                return false;
            }
        }
        if (this.isExceptMethodLevel && this.exceptMethodList != null) {
            for (String exceptMethod : this.exceptMethodList) {
                if (!it.getName().matches(exceptMethod)) continue;
                return false;
            }
        }
        if (this.isHotfixMethodLevel && this.hotfixMethodList != null) {
            for (String name : this.hotfixMethodList) {
                if (!it.getName().matches(name)) continue;
                return true;
            }
        }
        return !this.isHotfixMethodLevel;
    }

    private String getParametersClassType(CtMethod method) throws NotFoundException {
        if (method.getParameterTypes().length == 0) {
            return " null ";
        }
        StringBuilder parameterType = new StringBuilder();
        parameterType.append("new Class[]{");
        for (CtClass paramterClass : method.getParameterTypes()) {
            parameterType.append(paramterClass.getName()).append(".class,");
        }
        if (',' == parameterType.charAt(parameterType.length() - 1)) {
            parameterType.deleteCharAt(parameterType.length() - 1);
        }
        parameterType.append("}");
        return parameterType.toString();
    }

    private boolean isMethodWithExpression(CtMethod ctMethod) throws CannotCompileException {
        this.isCallMethod = false;
        if (ctMethod == null) {
            return false;
        }
        ctMethod.instrument(new ExprEditor(){

            public void edit(NewArray a) throws CannotCompileException {
                JavaAssistInsertImpl.this.isCallMethod = true;
            }

            public void edit(MethodCall m) throws CannotCompileException {
                JavaAssistInsertImpl.this.isCallMethod = true;
            }

            public void edit(ConstructorCall c) throws CannotCompileException {
                JavaAssistInsertImpl.this.isCallMethod = true;
            }

            public void edit(Instanceof i) throws CannotCompileException {
                JavaAssistInsertImpl.this.isCallMethod = true;
            }

            public void edit(Cast c) throws CannotCompileException {
                JavaAssistInsertImpl.this.isCallMethod = true;
            }

            public void edit(Handler h) throws CannotCompileException {
                JavaAssistInsertImpl.this.isCallMethod = true;
            }
        });
        return this.isCallMethod;
    }

    private String getReturnStatement(String type, boolean isStatic, int methodNumber, String parametersClassType, String returnTypeString) {
        switch (type) {
            case "Constructor": {
                return "    com.meituan.robust.PatchProxy.accessDispatchVoid( $args, argThis, changeQuickRedirect, " + isStatic + ", " + methodNumber + "," + parametersClassType + "," + returnTypeString + ");  ";
            }
            case "java.lang.Void": {
                return "    com.meituan.robust.PatchProxy.accessDispatchVoid( $args, argThis, changeQuickRedirect, " + isStatic + ", " + methodNumber + "," + parametersClassType + "," + returnTypeString + ");   return null;";
            }
            case "void": {
                return "    com.meituan.robust.PatchProxy.accessDispatchVoid( $args, argThis, changeQuickRedirect, " + isStatic + ", " + methodNumber + "," + parametersClassType + "," + returnTypeString + ");   return ;";
            }
            case "java.lang.Boolean": {
                return "   return ((java.lang.Boolean)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + "));";
            }
            case "boolean": {
                return "   return ((java.lang.Boolean)com.meituan.robust.PatchProxy.accessDispatch($args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).booleanValue();";
            }
            case "int": {
                return "   return ((java.lang.Integer)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).intValue();";
            }
            case "java.lang.Integer": {
                return "   return ((java.lang.Integer)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")); ";
            }
            case "long": {
                return "   return ((java.lang.Long)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).longValue();";
            }
            case "java.lang.Long": {
                return "   return ((java.lang.Long)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + "));";
            }
            case "double": {
                return "   return ((java.lang.Double)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).doubleValue();";
            }
            case "java.lang.Double": {
                return "   return ((java.lang.Double)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + "));";
            }
            case "float": {
                return "   return ((java.lang.Float)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).floatValue();";
            }
            case "java.lang.Float": {
                return "   return ((java.lang.Float)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + "));";
            }
            case "short": {
                return "   return ((java.lang.Short)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).shortValue();";
            }
            case "java.lang.Short": {
                return "   return ((java.lang.Short)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + "));";
            }
            case "byte": {
                return "   return ((java.lang.Byte)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).byteValue();";
            }
            case "java.lang.Byte": {
                return "   return ((java.lang.Byte)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + "));";
            }
            case "char": {
                return "   return ((java.lang.Character)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ")).charValue();";
            }
            case "Character": {
                return "   return ((java.lang.Character)com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + "));";
            }
        }
        return "   return (" + type + ")com.meituan.robust.PatchProxy.accessDispatch( $args, argThis, changeQuickRedirect, " + isStatic + "," + methodNumber + "," + parametersClassType + "," + returnTypeString + ");";
    }
}

