/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AbstractReplicator;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.DefaultExceptionListener;
import com.moilioncircle.redis.replicator.Status;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.RedisCodec;
import com.moilioncircle.redis.replicator.cmd.ReplyParser;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.event.PostCommandSyncEvent;
import com.moilioncircle.redis.replicator.event.PreCommandSyncEvent;
import com.moilioncircle.redis.replicator.io.PeekableInputStream;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.RdbParser;
import com.moilioncircle.redis.replicator.util.Strings;
import com.moilioncircle.redis.replicator.util.Tuples;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisMixReplicator
extends AbstractReplicator {
    protected static final Logger logger = LoggerFactory.getLogger(RedisMixReplicator.class);
    protected final ReplyParser replyParser;
    protected final PeekableInputStream peekable;

    public RedisMixReplicator(File file, Configuration configuration) throws FileNotFoundException {
        this(new FileInputStream(file), configuration);
    }

    public RedisMixReplicator(InputStream in, Configuration configuration) {
        Objects.requireNonNull(in);
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
        if (in instanceof PeekableInputStream) {
            this.peekable = (PeekableInputStream)in;
        } else {
            this.peekable = new PeekableInputStream(in);
            in = this.peekable;
        }
        this.inputStream = new RedisInputStream(in, this.configuration.getBufferSize());
        this.inputStream.setRawByteListeners(this.rawByteListeners);
        this.replyParser = new ReplyParser(this.inputStream, new RedisCodec());
        this.builtInCommandParserRegister();
        if (configuration.isUseDefaultExceptionListener()) {
            this.addExceptionListener(new DefaultExceptionListener());
        }
    }

    @Override
    public void open() throws IOException {
        super.open();
        if (!this.compareAndSet(Status.DISCONNECTED, Status.CONNECTED)) {
            return;
        }
        try {
            this.doOpen();
        }
        catch (UncheckedIOException e) {
            if (!(e.getCause() instanceof EOFException)) {
                throw e.getCause();
            }
        }
        finally {
            this.doClose();
            this.doCloseListener(this);
        }
    }

    protected void doOpen() throws IOException {
        this.configuration.setReplOffset(0L);
        if (this.peekable.peek() == 82) {
            RdbParser parser = new RdbParser(this.inputStream, this);
            this.configuration.setReplOffset(parser.parse());
        }
        if (this.getStatus() != Status.CONNECTED) {
            return;
        }
        this.submitEvent(new PreCommandSyncEvent());
        try {
            long[] offset = new long[1];
            while (this.getStatus() == Status.CONNECTED) {
                Object obj = this.replyParser.parse(len -> {
                    offset[0] = len;
                });
                if (obj instanceof Object[]) {
                    Object[] raw;
                    CommandName name;
                    CommandParser parser;
                    if (this.verbose() && logger.isDebugEnabled()) {
                        logger.debug(Strings.format((Object[])obj));
                    }
                    if ((parser = (CommandParser)this.commands.get(name = CommandName.name(Strings.toString((raw = (Object[])obj)[0])))) == null) {
                        logger.warn("command [{}] not register. raw command:{}", (Object)name, (Object)Strings.format(raw));
                        this.configuration.addOffset(offset[0]);
                        offset[0] = 0L;
                        continue;
                    }
                    long st = this.configuration.getReplOffset();
                    long ed = st + offset[0];
                    this.submitEvent((Event)parser.parse(raw), Tuples.of(st, ed));
                } else {
                    logger.warn("unexpected redis reply:{}", obj);
                }
                this.configuration.addOffset(offset[0]);
                offset[0] = 0L;
            }
        }
        catch (EOFException ignore) {
            this.submitEvent(new PostCommandSyncEvent());
        }
    }
}

