/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AsyncReplicator;
import com.moilioncircle.redis.replicator.Replicator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class Replicators {
    public static void open(Replicator replicator) {
        try {
            Objects.requireNonNull(replicator).open();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void close(Replicator replicator) {
        try {
            Objects.requireNonNull(replicator).close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void openQuietly(Replicator replicator) {
        try {
            Replicators.open(replicator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeQuietly(Replicator replicator) {
        try {
            Replicators.close(replicator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static CompletableFuture<Void> open(AsyncReplicator replicator) {
        return Replicators.open(replicator, null);
    }

    public static CompletableFuture<Void> close(AsyncReplicator replicator) {
        return Replicators.close(replicator, null);
    }

    public static CompletableFuture<Void> open(AsyncReplicator replicator, Executor executor) {
        return Objects.requireNonNull(replicator).open(executor);
    }

    public static CompletableFuture<Void> close(AsyncReplicator replicator, Executor executor) {
        return Objects.requireNonNull(replicator).close(executor);
    }
}

