/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib;

import com.netflix.dyno.connectionpool.ConnectionPoolConfiguration;
import com.netflix.dyno.connectionpool.ConnectionPoolConfigurationPublisher;
import com.netflix.dyno.contrib.ElasticConnectionPoolConfigurationPublisher;
import java.util.Locale;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolConfigPublisherFactory {
    private static final Logger Logger = LoggerFactory.getLogger(ConnectionPoolConfigPublisherFactory.class);

    public ConnectionPoolConfigurationPublisher createPublisher(String applicationName, String clusterName, ConnectionPoolConfiguration config) {
        if (config.getConfigurationPublisherConfig() != null) {
            try {
                ConnectionPoolConfigurationPublisher.PublisherType publisherType;
                String type;
                JSONObject json = new JSONObject(config.getConfigurationPublisherConfig());
                String vip = json.getString("vip");
                if (vip != null && (type = json.getString("type")) != null && ConnectionPoolConfigurationPublisher.PublisherType.ELASTIC == (publisherType = ConnectionPoolConfigurationPublisher.PublisherType.valueOf((String)type.toUpperCase(Locale.ENGLISH)))) {
                    return new ElasticConnectionPoolConfigurationPublisher(applicationName, clusterName, vip, config);
                }
            }
            catch (JSONException e) {
                Logger.warn("Invalid json specified for config publisher: " + e.getMessage());
            }
        }
        return null;
    }
}

