/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib;

import com.netflix.dyno.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynoCPMonitor
extends CountingConnectionPoolMonitor {
    private static final Logger Logger = LoggerFactory.getLogger(DynoCPMonitor.class);

    public DynoCPMonitor(String namePrefix) {
        try {
            DefaultMonitorRegistry.getInstance().register((Monitor)Monitors.newObjectMonitor((String)namePrefix, (Object)((Object)this)));
        }
        catch (Exception e) {
            Logger.warn("Failed to register metrics with monitor registry", (Throwable)e);
        }
    }

    @com.netflix.servo.annotations.Monitor(name="OperationSuccess", type=DataSourceType.COUNTER)
    public long getOperationSuccessCount() {
        return super.getOperationSuccessCount();
    }

    @com.netflix.servo.annotations.Monitor(name="OperationFailure", type=DataSourceType.COUNTER)
    public long getOperationFailureCount() {
        return super.getOperationFailureCount();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionCreated", type=DataSourceType.COUNTER)
    public long getConnectionCreatedCount() {
        return super.getConnectionCreatedCount();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionClosed", type=DataSourceType.COUNTER)
    public long getConnectionClosedCount() {
        return super.getConnectionClosedCount();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionCreateFailed", type=DataSourceType.COUNTER)
    public long getConnectionCreateFailedCount() {
        return super.getConnectionCreateFailedCount();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionBorrowed", type=DataSourceType.COUNTER)
    public long getConnectionBorrowedCount() {
        return super.getConnectionBorrowedCount();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionBorrowedAvgLat", type=DataSourceType.GAUGE)
    public long getConnectionBorrowedLatMean() {
        return super.getConnectionBorrowedLatMean();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionBorrowedLatP50", type=DataSourceType.GAUGE)
    public long getConnectionBorrowedLatP50() {
        return super.getConnectionBorrowedLatP50();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionBorrowedLatP99", type=DataSourceType.GAUGE)
    public long getConnectionBorrowedLatP99() {
        return super.getConnectionBorrowedLatP99();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionReturned", type=DataSourceType.COUNTER)
    public long getConnectionReturnedCount() {
        return super.getConnectionReturnedCount();
    }

    @com.netflix.servo.annotations.Monitor(name="PoolExhausted", type=DataSourceType.COUNTER)
    public long getPoolExhaustedTimeoutCount() {
        return super.getPoolExhaustedTimeoutCount();
    }

    @com.netflix.servo.annotations.Monitor(name="SocketTimeout", type=DataSourceType.COUNTER)
    public long getSocketTimeoutCount() {
        return super.getSocketTimeoutCount();
    }

    @com.netflix.servo.annotations.Monitor(name="OperationTimeout", type=DataSourceType.COUNTER)
    public long getOperationTimeoutCount() {
        return super.getOperationTimeoutCount();
    }

    @com.netflix.servo.annotations.Monitor(name="NumFailover", type=DataSourceType.COUNTER)
    public long getFailoverCount() {
        return super.getFailoverCount();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionBusy", type=DataSourceType.COUNTER)
    public long getNumBusyConnections() {
        return super.getNumBusyConnections();
    }

    @com.netflix.servo.annotations.Monitor(name="ConnectionOpen", type=DataSourceType.COUNTER)
    public long getNumOpenConnections() {
        return super.getNumOpenConnections();
    }

    @com.netflix.servo.annotations.Monitor(name="NoHostCount", type=DataSourceType.COUNTER)
    public long getNoHostCount() {
        return super.getNoHostCount();
    }

    @com.netflix.servo.annotations.Monitor(name="UnknownError", type=DataSourceType.COUNTER)
    public long getUnknownErrorCount() {
        return super.getUnknownErrorCount();
    }

    @com.netflix.servo.annotations.Monitor(name="BadRequest", type=DataSourceType.COUNTER)
    public long getBadRequestCount() {
        return super.getBadRequestCount();
    }

    @com.netflix.servo.annotations.Monitor(name="HostCount", type=DataSourceType.GAUGE)
    public long getHostCount() {
        return super.getHostCount();
    }

    @com.netflix.servo.annotations.Monitor(name="HostUpCount", type=DataSourceType.GAUGE)
    public long getHostUpCount() {
        return super.getHostUpCount();
    }

    @com.netflix.servo.annotations.Monitor(name="HostDownCount", type=DataSourceType.GAUGE)
    public long getHostDownCount() {
        return super.getHostDownCount();
    }
}

