/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaHostsSupplier
implements HostSupplier {
    private static final Logger Logger = LoggerFactory.getLogger(EurekaHostsSupplier.class);
    private final String applicationName;
    private final EurekaClient discoveryClient;

    @Deprecated
    public EurekaHostsSupplier(String applicationName, DiscoveryClient dClient) {
        this.applicationName = applicationName.toUpperCase();
        this.discoveryClient = dClient;
    }

    public EurekaHostsSupplier(String applicationName, EurekaClient dClient) {
        this.applicationName = applicationName.toUpperCase();
        this.discoveryClient = dClient;
    }

    public static EurekaHostsSupplier newInstance(String applicationName, EurekaHostsSupplier hostsSupplier) {
        return new EurekaHostsSupplier(applicationName, hostsSupplier.getDiscoveryClient());
    }

    public List<Host> getHosts() {
        return this.getUpdateFromEureka();
    }

    private List<Host> getUpdateFromEureka() {
        if (this.discoveryClient == null) {
            Logger.error("Discovery client cannot be null");
            throw new RuntimeException("EurekaHostsSupplier needs a non-null DiscoveryClient");
        }
        Logger.info("Dyno fetching instance list for app: " + this.applicationName);
        Application app = this.discoveryClient.getApplication(this.applicationName);
        ArrayList hosts = new ArrayList();
        if (app == null) {
            return hosts;
        }
        List ins = app.getInstances();
        if (ins == null || ins.isEmpty()) {
            return hosts;
        }
        hosts = Lists.newArrayList((Iterable)Collections2.transform((Collection)ins, (Function)new Function<InstanceInfo, Host>(){

            public Host apply(InstanceInfo info) {
                Host.Status status = info.getStatus() == InstanceInfo.InstanceStatus.UP ? Host.Status.Up : Host.Status.Down;
                String rack = null;
                try {
                    if (info.getDataCenterInfo() instanceof AmazonInfo) {
                        AmazonInfo amazonInfo = (AmazonInfo)info.getDataCenterInfo();
                        rack = amazonInfo.get(AmazonInfo.MetaDataKey.availabilityZone);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Error getting rack for host " + info.getHostName(), t);
                }
                if (rack == null) {
                    Logger.error("Rack wasn't found for host:" + info.getHostName() + " there may be issues matching it up to the token map");
                }
                Host host = new Host(info.getHostName(), info.getIPAddr(), rack, status);
                return host;
            }
        }));
        Logger.info("Dyno found hosts from eureka - num hosts: " + hosts.size());
        return hosts;
    }

    public String toString() {
        return EurekaHostsSupplier.class.getName();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public EurekaClient getDiscoveryClient() {
        return this.discoveryClient;
    }
}

