/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.dyno.connectionpool.ConnectionPoolConfiguration;
import com.netflix.dyno.connectionpool.ErrorRateMonitorConfig;
import com.netflix.dyno.connectionpool.RetryPolicy;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.dyno.connectionpool.impl.RetryNTimes;
import com.netflix.dyno.connectionpool.impl.RunOnce;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchaiusConnectionPoolConfiguration
extends ConnectionPoolConfigurationImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ArchaiusConnectionPoolConfiguration.class);
    private static final String DynoPrefix = "dyno.";
    private final DynamicIntProperty maxConnsPerHost;
    private final DynamicIntProperty maxTimeoutWhenExhausted;
    private final DynamicIntProperty maxFailoverCount;
    private final DynamicIntProperty connectTimeout;
    private final DynamicIntProperty socketTimeout;
    private final DynamicBooleanProperty localZoneAffinity;
    private final DynamicIntProperty resetTimingsFrequency;
    private final DynamicStringProperty configPublisherConfig;
    private final DynamicIntProperty compressionThreshold;
    private final ConnectionPoolConfiguration.LoadBalancingStrategy loadBalanceStrategy;
    private final ConnectionPoolConfiguration.CompressionStrategy compressionStrategy;
    private final ErrorRateMonitorConfig errorRateConfig;
    private final RetryPolicy.RetryPolicyFactory retryPolicyFactory;
    private final DynamicBooleanProperty failOnStartupIfNoHosts;
    private DynamicBooleanProperty isDualWriteEnabled;
    private DynamicStringProperty dualWriteClusterName;
    private DynamicIntProperty dualWritePercentage;

    public ArchaiusConnectionPoolConfiguration(String name) {
        super(name);
        String propertyPrefix = DynoPrefix + name;
        this.maxConnsPerHost = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".connection.maxConnsPerHost", super.getMaxConnsPerHost());
        this.maxTimeoutWhenExhausted = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".connection.maxTimeoutWhenExhausted", super.getMaxTimeoutWhenExhausted());
        this.maxFailoverCount = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".connection.maxFailoverCount", super.getMaxFailoverCount());
        this.connectTimeout = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".connection.connectTimeout", super.getConnectTimeout());
        this.socketTimeout = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".connection.socketTimeout", super.getSocketTimeout());
        this.localZoneAffinity = DynamicPropertyFactory.getInstance().getBooleanProperty(propertyPrefix + ".connection.localZoneAffinity", super.localZoneAffinity());
        this.resetTimingsFrequency = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".connection.metrics.resetFrequencySeconds", super.getTimingCountersResetFrequencySeconds());
        this.configPublisherConfig = DynamicPropertyFactory.getInstance().getStringProperty(propertyPrefix + ".config.publisher.address", super.getConfigurationPublisherConfig());
        this.failOnStartupIfNoHosts = DynamicPropertyFactory.getInstance().getBooleanProperty(propertyPrefix + ".config.startup.failIfNoHosts", super.getFailOnStartupIfNoHosts());
        this.compressionThreshold = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".config.compressionThreshold", super.getValueCompressionThreshold());
        this.loadBalanceStrategy = this.parseLBStrategy(propertyPrefix);
        this.errorRateConfig = this.parseErrorRateMonitorConfig(propertyPrefix);
        this.retryPolicyFactory = this.parseRetryPolicyFactory(propertyPrefix);
        this.compressionStrategy = this.parseCompressionStrategy(propertyPrefix);
        this.isDualWriteEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty(propertyPrefix + ".dualwrite.enabled", super.isDualWriteEnabled());
        this.dualWriteClusterName = DynamicPropertyFactory.getInstance().getStringProperty(propertyPrefix + ".dualwrite.cluster", super.getDualWriteClusterName());
        this.dualWritePercentage = DynamicPropertyFactory.getInstance().getIntProperty(propertyPrefix + ".dualwrite.percentage", super.getDualWritePercentage());
    }

    public String getName() {
        return super.getName();
    }

    public int getMaxConnsPerHost() {
        return this.maxConnsPerHost.get();
    }

    public int getMaxTimeoutWhenExhausted() {
        return this.maxTimeoutWhenExhausted.get();
    }

    public int getMaxFailoverCount() {
        return this.maxFailoverCount.get();
    }

    public int getConnectTimeout() {
        return this.connectTimeout.get();
    }

    public int getSocketTimeout() {
        return this.socketTimeout.get();
    }

    public RetryPolicy.RetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public boolean localZoneAffinity() {
        return this.localZoneAffinity.get();
    }

    public ConnectionPoolConfiguration.LoadBalancingStrategy getLoadBalancingStrategy() {
        return this.loadBalanceStrategy;
    }

    public ConnectionPoolConfiguration.CompressionStrategy getCompressionStrategy() {
        return this.compressionStrategy;
    }

    public int getValueCompressionThreshold() {
        return this.compressionThreshold.get();
    }

    public int getTimingCountersResetFrequencySeconds() {
        return this.resetTimingsFrequency.get();
    }

    public String getConfigurationPublisherConfig() {
        return this.configPublisherConfig.get();
    }

    public boolean getFailOnStartupIfNoHosts() {
        return this.failOnStartupIfNoHosts.get();
    }

    public boolean isDualWriteEnabled() {
        return this.isDualWriteEnabled.get();
    }

    public String getDualWriteClusterName() {
        return this.dualWriteClusterName.get();
    }

    public int getDualWritePercentage() {
        return this.dualWritePercentage.get();
    }

    public void setIsDualWriteEnabled(DynamicBooleanProperty booleanProperty) {
        this.isDualWriteEnabled = booleanProperty;
    }

    public void setDualWriteClusterName(DynamicStringProperty stringProperty) {
        this.dualWriteClusterName = stringProperty;
    }

    public void setDualWritePercentage(DynamicIntProperty intProperty) {
        this.dualWritePercentage = intProperty;
    }

    public String toString() {
        return "ArchaiusConnectionPoolConfiguration{name=" + this.getName() + ", maxConnsPerHost=" + this.maxConnsPerHost + ", maxTimeoutWhenExhausted=" + this.maxTimeoutWhenExhausted + ", maxFailoverCount=" + this.maxFailoverCount + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", localZoneAffinity=" + this.localZoneAffinity + ", resetTimingsFrequency=" + this.resetTimingsFrequency + ", configPublisherConfig=" + this.configPublisherConfig + ", compressionThreshold=" + this.compressionThreshold + ", loadBalanceStrategy=" + this.loadBalanceStrategy + ", compressionStrategy=" + this.compressionStrategy + ", errorRateConfig=" + this.errorRateConfig + ", retryPolicyFactory=" + this.retryPolicyFactory + ", failOnStartupIfNoHosts=" + this.failOnStartupIfNoHosts + ", isDualWriteEnabled=" + this.isDualWriteEnabled + ", dualWriteClusterName=" + this.dualWriteClusterName + ", dualWritePercentage=" + this.dualWritePercentage + '}';
    }

    private ConnectionPoolConfiguration.LoadBalancingStrategy parseLBStrategy(String propertyPrefix) {
        ConnectionPoolConfiguration.LoadBalancingStrategy defaultConfig = super.getLoadBalancingStrategy();
        String cfg = DynamicPropertyFactory.getInstance().getStringProperty(propertyPrefix + ".lbStrategy", defaultConfig.name()).get();
        ConnectionPoolConfiguration.LoadBalancingStrategy lb = null;
        try {
            lb = ConnectionPoolConfiguration.LoadBalancingStrategy.valueOf((String)cfg);
        }
        catch (Exception e) {
            Logger.warn("Unable to parse LoadBalancingStrategy: " + cfg + ", switching to default: " + defaultConfig.name());
            lb = defaultConfig;
        }
        return lb;
    }

    private ConnectionPoolConfiguration.CompressionStrategy parseCompressionStrategy(String propertyPrefix) {
        ConnectionPoolConfiguration.CompressionStrategy defaultCompStrategy = super.getCompressionStrategy();
        String cfg = DynamicPropertyFactory.getInstance().getStringProperty(propertyPrefix + ".compressionStrategy", defaultCompStrategy.name()).get();
        ConnectionPoolConfiguration.CompressionStrategy cs = null;
        try {
            cs = ConnectionPoolConfiguration.CompressionStrategy.valueOf((String)cfg);
            Logger.info("Dyno configuration: CompressionStrategy = " + cs.name());
        }
        catch (IllegalArgumentException ex) {
            Logger.warn("Unable to parse CompressionStrategy: " + cfg + ", switching to default: " + defaultCompStrategy.name());
            cs = defaultCompStrategy;
        }
        return cs;
    }

    private ErrorRateMonitorConfig parseErrorRateMonitorConfig(String propertyPrefix) {
        String errorRateConfig = DynamicPropertyFactory.getInstance().getStringProperty(propertyPrefix + ".errorRateConfig", null).get();
        try {
            if (errorRateConfig == null) {
                return null;
            }
            JSONObject json = new JSONObject(errorRateConfig);
            int window = json.getInt("window");
            int frequency = json.getInt("frequency");
            int suppress = json.getInt("suppress");
            ConnectionPoolConfigurationImpl.ErrorRateMonitorConfigImpl configImpl = new ConnectionPoolConfigurationImpl.ErrorRateMonitorConfigImpl(window, frequency, suppress);
            JSONArray thresholds = json.getJSONArray("thresholds");
            for (int i = 0; i < thresholds.length(); ++i) {
                JSONObject tConfig = thresholds.getJSONObject(i);
                int rps = tConfig.getInt("rps");
                int seconds = tConfig.getInt("seconds");
                int coverage = tConfig.getInt("coverage");
                configImpl.addThreshold(rps, seconds, coverage);
            }
            return configImpl;
        }
        catch (Exception e) {
            Logger.warn("Failed to parse error rate config: " + errorRateConfig, (Throwable)e);
            return new ConnectionPoolConfigurationImpl.ErrorRateMonitorConfigImpl();
        }
    }

    private RetryPolicy.RetryPolicyFactory parseRetryPolicyFactory(String propertyPrefix) {
        String retryPolicy = DynamicPropertyFactory.getInstance().getStringProperty(propertyPrefix + ".retryPolicy", "RunOnce").get();
        if (retryPolicy.equals("RunOnce")) {
            return new RunOnce.RetryFactory();
        }
        if (retryPolicy.startsWith("RetryNTimes")) {
            String[] parts = retryPolicy.split(":");
            if (parts.length < 2) {
                return new RunOnce.RetryFactory();
            }
            try {
                int n = Integer.parseInt(parts[1]);
                boolean allowFallback = false;
                if (parts.length == 3) {
                    allowFallback = Boolean.parseBoolean(parts[2]);
                }
                return new RetryNTimes.RetryFactory(n, allowFallback);
            }
            catch (Exception e) {
                return new RunOnce.RetryFactory();
            }
        }
        return new RunOnce.RetryFactory();
    }
}

