/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib;

import com.netflix.dyno.connectionpool.OperationMonitor;
import com.netflix.dyno.connectionpool.impl.utils.EstimatedHistogram;
import com.netflix.dyno.contrib.EstimatedHistogramBasedCounter;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class DynoOPMonitor
implements OperationMonitor {
    private final ConcurrentHashMap<String, DynoOpCounter> counterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DynoTimingCounters> timerMap = new ConcurrentHashMap();
    private final String appName;

    public DynoOPMonitor(String applicationName) {
        this.appName = applicationName;
    }

    public void recordLatency(String opName, long duration, TimeUnit unit) {
        this.getOrCreateTimers(opName).recordLatency(duration, unit);
    }

    public void recordSuccess(String opName) {
        this.getOrCreateCounter(opName, false).incrementSuccess();
    }

    public void recordFailure(String opName, String reason) {
        this.getOrCreateCounter(opName, false).incrementFailure();
    }

    public void recordSuccess(String opName, boolean compressionEnabled) {
        this.getOrCreateCounter(opName, compressionEnabled).incrementSuccess();
    }

    public void recordFailure(String opName, boolean compressionEnabled, String reason) {
        this.getOrCreateCounter(opName, true).incrementFailure();
    }

    private DynoOpCounter getOrCreateCounter(String opName, boolean compressionEnabled) {
        String counterName = opName + "_" + compressionEnabled;
        DynoOpCounter counter = this.counterMap.get(counterName);
        if (counter != null) {
            return counter;
        }
        counter = new DynoOpCounter(this.appName, counterName);
        DynoOpCounter prevCounter = this.counterMap.putIfAbsent(counterName, counter);
        if (prevCounter != null) {
            return prevCounter;
        }
        DefaultMonitorRegistry.getInstance().register((Monitor)counter.success);
        DefaultMonitorRegistry.getInstance().register((Monitor)counter.failure);
        DefaultMonitorRegistry.getInstance().register((Monitor)counter.successCompressionEnabled);
        DefaultMonitorRegistry.getInstance().register((Monitor)counter.failureCompressionEnabled);
        return counter;
    }

    private DynoTimingCounters getOrCreateTimers(String opName) {
        DynoTimingCounters timer = this.timerMap.get(opName);
        if (timer != null) {
            return timer;
        }
        timer = new DynoTimingCounters(this.appName, opName);
        DynoTimingCounters prevTimer = this.timerMap.putIfAbsent(opName, timer);
        if (prevTimer != null) {
            return prevTimer;
        }
        DefaultMonitorRegistry.getInstance().register((Monitor)timer.latMean);
        DefaultMonitorRegistry.getInstance().register((Monitor)timer.lat99);
        DefaultMonitorRegistry.getInstance().register((Monitor)timer.lat995);
        DefaultMonitorRegistry.getInstance().register((Monitor)timer.lat999);
        return timer;
    }

    private class DynoTimingCounters {
        private final EstimatedHistogramBasedCounter.EstimatedHistogramMean latMean;
        private final EstimatedHistogramBasedCounter.EstimatedHistogramPercentile lat99;
        private final EstimatedHistogramBasedCounter.EstimatedHistogramPercentile lat995;
        private final EstimatedHistogramBasedCounter.EstimatedHistogramPercentile lat999;
        private final EstimatedHistogram estHistogram = new EstimatedHistogram();

        private DynoTimingCounters(String appName, String opName) {
            this.latMean = new EstimatedHistogramBasedCounter.EstimatedHistogramMean("Dyno__" + appName + "__" + opName + "__latMean", opName, this.estHistogram);
            this.lat99 = new EstimatedHistogramBasedCounter.EstimatedHistogramPercentile("Dyno__" + appName + "__" + opName + "__lat990", opName, this.estHistogram, 0.99);
            this.lat995 = new EstimatedHistogramBasedCounter.EstimatedHistogramPercentile("Dyno__" + appName + "__" + opName + "__lat995", opName, this.estHistogram, 0.995);
            this.lat999 = new EstimatedHistogramBasedCounter.EstimatedHistogramPercentile("Dyno__" + appName + "__" + opName + "__lat999", opName, this.estHistogram, 0.999);
        }

        public void recordLatency(long duration, TimeUnit unit) {
            long durationMicros = TimeUnit.MICROSECONDS.convert(duration, unit);
            this.estHistogram.add(durationMicros);
        }
    }

    private class DynoOpCounter {
        private final Counter success;
        private final Counter successCompressionEnabled;
        private final Counter failure;
        private final Counter failureCompressionEnabled;

        private DynoOpCounter(String appName, String opName) {
            this.success = this.getNewCounter("Dyno__" + appName + "__" + opName + "__SUCCESS", opName, "false");
            this.successCompressionEnabled = this.getNewCounter("Dyno__" + appName + "__" + opName + "__SUCCESS", opName, "true");
            this.failure = this.getNewCounter("Dyno__" + appName + "__" + opName + "__ERROR", opName, "false");
            this.failureCompressionEnabled = this.getNewCounter("Dyno__" + appName + "__" + opName + "__ERROR", opName, "true");
        }

        private void incrementSuccess() {
            this.success.increment();
        }

        private void incrementFailure() {
            this.failure.increment();
        }

        private BasicCounter getNewCounter(String metricName, String opName, String compressionEnabled) {
            MonitorConfig config = MonitorConfig.builder((String)metricName).withTag((Tag)new BasicTag("dyno_op", opName)).withTag((Tag)new BasicTag("compression_enabled", compressionEnabled)).build();
            return new BasicCounter(config);
        }
    }
}

