/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib;

import com.netflix.dyno.connectionpool.ConnectionPoolConfiguration;
import com.netflix.dyno.connectionpool.ConnectionPoolConfigurationPublisher;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticConnectionPoolConfigurationPublisher
implements ConnectionPoolConfigurationPublisher {
    private static final Logger Logger = LoggerFactory.getLogger(ElasticConnectionPoolConfigurationPublisher.class);
    private final String applicationName;
    private final String clusterName;
    private final String vip;
    private final ConnectionPoolConfiguration config;
    private static final String DESTINATION = "http://%s:7104/clientinfo/dyno";

    public ElasticConnectionPoolConfigurationPublisher(String applicationName, String clusterName, String vip, ConnectionPoolConfiguration config) {
        this.applicationName = applicationName;
        this.clusterName = clusterName;
        this.vip = vip;
        this.config = config;
    }

    public void publish() {
        try {
            String destination = String.format(DESTINATION, this.vip);
            this.executePost(destination, this.createJsonFromConfig(this.config));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    JSONObject createJsonFromConfig(ConnectionPoolConfiguration config) throws JSONException {
        Method[] methods;
        if (config == null) {
            throw new IllegalArgumentException("Valid ConnectionPoolConfiguration instance is required");
        }
        JSONObject json = new JSONObject();
        json.put("ApplicationName", (Object)this.applicationName);
        json.put("DynomiteClusterName", (Object)this.clusterName);
        for (Method method : methods = config.getClass().getMethods()) {
            Class<?> ret;
            if (!method.getName().startsWith("get") || !(ret = method.getReturnType()).isPrimitive() && ret != String.class) continue;
            try {
                json.put(method.getName().substring(3), method.invoke((Object)config, new Object[0]));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        HashSet<String> jars = new HashSet<String>(){
            {
                this.add("dyno-core");
                this.add("dyno-contrib");
                this.add("dyno-jedis");
                this.add("dyno-reddison");
            }
        };
        json.put("Versions", (Object)new JSONObject(this.getLibraryVersion(this.getClass(), (Set<String>)jars)));
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executePost(String destination, JSONObject jsonObject) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(destination);
        try {
            StringEntity entity = new StringEntity(jsonObject.toString());
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null) {
                if (200 >= statusLine.getStatusCode() && statusLine.getStatusCode() < 300) {
                    Logger.info("successfully published runtime data to http://%s:7104/clientinfo/dyno");
                } else {
                    Logger.info(String.format("unable to publish runtime data: %d %s ", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                }
            }
        }
        catch (UnsupportedEncodingException ue) {
            Logger.warn("Unable to create entity to post from json " + jsonObject.toString());
        }
        catch (IOException e) {
            Logger.warn("Unable to post configuration data to elastic cluster: " + destination);
        }
        catch (Throwable th) {
            Logger.warn("Unable to post configuration data to elastic cluster:" + th.getMessage());
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    Map<String, String> getLibraryVersion(Class<?> classLoadedWithURLClassLoader, Set<String> libraryNames) {
        ClassLoader cl = classLoadedWithURLClassLoader.getClassLoader();
        HashMap<String, String> libraryVersionMapping = new HashMap<String, String>();
        if (cl instanceof URLClassLoader) {
            URL[] urls;
            URLClassLoader uCl = (URLClassLoader)cl;
            for (URL url : urls = uCl.getURLs()) {
                String name;
                String nameWithVersion;
                int idx;
                String fullNameWithVersion = url.toString().substring(url.toString().lastIndexOf(47));
                if (fullNameWithVersion.length() <= 4 || (idx = this.findVersionStartIndex(nameWithVersion = fullNameWithVersion.substring(1, fullNameWithVersion.length() - 4))) <= 0 || !libraryNames.contains(name = nameWithVersion.substring(0, idx - 1))) continue;
                libraryVersionMapping.put(name, nameWithVersion.substring(idx));
            }
        }
        return libraryVersionMapping;
    }

    Map<String, String> getLibraryVersion(Class<?> classLoadedWithURLClassLoader, String ... libraryNames) {
        return this.getLibraryVersion(classLoadedWithURLClassLoader, new HashSet<String>(Arrays.asList(libraryNames)));
    }

    int findVersionStartIndex(String nameWithVersion) {
        if (nameWithVersion != null) {
            char[] chars = nameWithVersion.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != '-' || i >= chars.length || !Character.isDigit(chars[i + 1])) continue;
                return i + 1;
            }
        }
        return -1;
    }
}

