/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.netflix.dyno.connectionpool.impl.utils.EstimatedHistogram;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;

public abstract class EstimatedHistogramBasedCounter
extends AbstractMonitor<Number> {
    protected final EstimatedHistogram estHistogram;

    public EstimatedHistogramBasedCounter(String name, String opName, EstimatedHistogram histogram) {
        super(MonitorConfig.builder((String)name).build().withAdditionalTag((Tag)DataSourceType.GAUGE).withAdditionalTag((Tag)new BasicTag("dyno_op", opName)));
        this.estHistogram = histogram;
    }

    public EstimatedHistogramBasedCounter(String name, String opName, String tagName, EstimatedHistogram histogram) {
        super(MonitorConfig.builder((String)name).build().withAdditionalTag((Tag)DataSourceType.GAUGE).withAdditionalTag((Tag)new BasicTag(tagName, opName)));
        this.estHistogram = histogram;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EstimatedHistogramBasedCounter)) {
            return false;
        }
        EstimatedHistogramBasedCounter m = (EstimatedHistogramBasedCounter)((Object)obj);
        return this.config.equals((Object)m.getConfig()) && this.estHistogram.equals((Object)m.estHistogram);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.estHistogram.hashCode()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("config", (Object)this.config).add("count", this.getValue()).toString();
    }

    public static class EstimatedHistogramPercentile
    extends EstimatedHistogramBasedCounter {
        private final double percentile;

        public EstimatedHistogramPercentile(String name, String opName, EstimatedHistogram histogram, double pVal) {
            super(name, opName, histogram);
            this.percentile = pVal;
        }

        public EstimatedHistogramPercentile(String name, String opName, String tagName, EstimatedHistogram histogram, double pVal) {
            super(name, opName, tagName, histogram);
            this.percentile = pVal;
        }

        public Number getValue() {
            return this.estHistogram.percentile(this.percentile);
        }

        public Number getValue(int pollerIndex) {
            return this.estHistogram.percentile(this.percentile);
        }
    }

    public static class EstimatedHistogramMean
    extends EstimatedHistogramBasedCounter {
        public EstimatedHistogramMean(String name, String opName, EstimatedHistogram histogram) {
            super(name, opName, histogram);
        }

        public EstimatedHistogramMean(String name, String opName, String tagName, EstimatedHistogram histogram) {
            super(name, opName, tagName, histogram);
        }

        public Number getValue() {
            return this.estHistogram.mean();
        }

        public Number getValue(int pollerIndex) {
            return this.estHistogram.mean();
        }

        public void add(long n) {
            this.estHistogram.add(n);
        }

        public void reset() {
            this.estHistogram.getBuckets(true);
        }
    }
}

