/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib.consul;

import com.ecwid.consul.v1.health.model.HealthService;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConsulHelper {
    public static String findHost(HealthService healthService) {
        HealthService.Service service = healthService.getService();
        HealthService.Node node = healthService.getNode();
        if (StringUtils.isNotBlank((CharSequence)service.getAddress())) {
            return service.getAddress();
        }
        if (StringUtils.isNotBlank((CharSequence)node.getAddress())) {
            return node.getAddress();
        }
        return node.getNode();
    }

    public static Map<String, String> getMetadata(HealthService healthService) {
        return ConsulHelper.getMetadata(healthService.getService().getTags());
    }

    public static Map<String, String> getMetadata(List<String> tags) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        if (tags != null) {
            block5: for (String tag : tags) {
                String[] parts = StringUtils.split((String)tag, (String)"=");
                switch (parts.length) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        metadata.put(parts[0], parts[0]);
                        continue block5;
                    }
                    case 2: {
                        metadata.put(parts[0], parts[1]);
                        continue block5;
                    }
                }
                Object[] end = Arrays.copyOfRange(parts, 1, parts.length);
                metadata.put(parts[0], StringUtils.join((Object[])end, (String)"="));
            }
        }
        return metadata;
    }
}

