/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.contrib.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.model.Check;
import com.ecwid.consul.v1.health.model.HealthService;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.contrib.consul.ConsulHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulHostsSupplier
implements HostSupplier {
    private static final Logger Logger = LoggerFactory.getLogger(ConsulHostsSupplier.class);
    private final String applicationName;
    private final ConsulClient discoveryClient;

    public ConsulHostsSupplier(String applicationName, ConsulClient discoveryClient) {
        this.applicationName = applicationName;
        this.discoveryClient = discoveryClient;
    }

    public static ConsulHostsSupplier newInstance(String applicationName, ConsulHostsSupplier hostsSupplier) {
        return new ConsulHostsSupplier(applicationName, hostsSupplier.getDiscoveryClient());
    }

    public List<Host> getHosts() {
        return this.getUpdateFromConsul();
    }

    private List<Host> getUpdateFromConsul() {
        if (this.discoveryClient == null) {
            Logger.error("Discovery client cannot be null");
            throw new RuntimeException("ConsulHostsSupplier needs a non-null DiscoveryClient");
        }
        Logger.info("Dyno fetching instance list for app: " + this.applicationName);
        Response services = this.discoveryClient.getHealthServices(this.applicationName, false, QueryParams.DEFAULT);
        List app = (List)services.getValue();
        ArrayList hosts = new ArrayList();
        if (app != null && app.size() < 0) {
            return hosts;
        }
        hosts = Lists.newArrayList((Iterable)Collections2.transform((Collection)app, (Function)new Function<HealthService, Host>(){

            public Host apply(HealthService info) {
                String hostName = ConsulHelper.findHost(info);
                Map<String, String> metaData = ConsulHelper.getMetadata(info);
                Host.Status status = Host.Status.Up;
                for (Check check : info.getChecks()) {
                    if (check.getStatus() != Check.CheckStatus.CRITICAL) continue;
                    status = Host.Status.Down;
                    break;
                }
                String rack = null;
                try {
                    rack = metaData.containsKey("cloud") && StringUtils.equals((CharSequence)metaData.get("cloud"), (CharSequence)"aws") ? metaData.get("availability-zone") : metaData.get("rack");
                }
                catch (Throwable t) {
                    Logger.error("Error getting rack for host " + info.getNode(), t);
                }
                if (rack == null) {
                    Logger.error("Rack wasn't found for host:" + info.getNode() + " there may be issues matching it up to the token map");
                }
                Host host = new Host(hostName, hostName, info.getService().getPort().intValue(), rack, String.valueOf(metaData.get("datacenter")), status);
                return host;
            }
        }));
        Logger.info("Dyno found hosts from consul - num hosts: " + hosts.size());
        return hosts;
    }

    public String toString() {
        return ConsulHostsSupplier.class.getName();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ConsulClient getDiscoveryClient() {
        return this.discoveryClient;
    }
}

