/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.dyno.connectionpool.CompressionOperation;
import com.netflix.dyno.connectionpool.ConnectionContext;
import com.netflix.dyno.connectionpool.ConnectionFactory;
import com.netflix.dyno.connectionpool.ConnectionPool;
import com.netflix.dyno.connectionpool.ConnectionPoolConfiguration;
import com.netflix.dyno.connectionpool.ConnectionPoolMonitor;
import com.netflix.dyno.connectionpool.CursorBasedResult;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.Operation;
import com.netflix.dyno.connectionpool.OperationMonitor;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import com.netflix.dyno.connectionpool.TopologyView;
import com.netflix.dyno.connectionpool.exception.DynoConnectException;
import com.netflix.dyno.connectionpool.exception.DynoException;
import com.netflix.dyno.connectionpool.exception.NoAvailableHostsException;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolImpl;
import com.netflix.dyno.connectionpool.impl.lb.HostToken;
import com.netflix.dyno.connectionpool.impl.lb.HttpEndpointBasedTokenMapSupplier;
import com.netflix.dyno.connectionpool.impl.utils.CollectionUtils;
import com.netflix.dyno.connectionpool.impl.utils.ZipUtils;
import com.netflix.dyno.contrib.ArchaiusConnectionPoolConfiguration;
import com.netflix.dyno.contrib.DynoCPMonitor;
import com.netflix.dyno.contrib.DynoOPMonitor;
import com.netflix.dyno.contrib.EurekaHostsSupplier;
import com.netflix.dyno.jedis.CursorBasedResultImpl;
import com.netflix.dyno.jedis.DynoDualWriterClient;
import com.netflix.dyno.jedis.DynoJedisPipeline;
import com.netflix.dyno.jedis.DynoJedisPipelineMonitor;
import com.netflix.dyno.jedis.JedisConnectionFactory;
import com.netflix.dyno.jedis.OpName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.MultiKeyCommands;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ScriptingCommands;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class DynoJedisClient
implements JedisCommands,
BinaryJedisCommands,
MultiKeyCommands,
ScriptingCommands {
    private static final Logger Logger = LoggerFactory.getLogger(DynoJedisClient.class);
    private final String appName;
    private final String clusterName;
    private final ConnectionPool<Jedis> connPool;
    private final AtomicReference<DynoJedisPipelineMonitor> pipelineMonitor = new AtomicReference();
    private final EnumSet<OpName> compressionOperations = EnumSet.of(OpName.APPEND);
    protected final DynoOPMonitor opMonitor;
    protected final ConnectionPoolMonitor cpMonitor;

    public DynoJedisClient(String name, String clusterName, ConnectionPool<Jedis> pool, DynoOPMonitor operationMonitor, ConnectionPoolMonitor cpMonitor) {
        this.appName = name;
        this.clusterName = clusterName;
        this.connPool = pool;
        this.opMonitor = operationMonitor;
        this.cpMonitor = cpMonitor;
    }

    public ConnectionPoolImpl<Jedis> getConnPool() {
        return (ConnectionPoolImpl)this.connPool;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public TopologyView getTopologyView() {
        return this.getConnPool();
    }

    public Long append(String key, String value) {
        return (Long)this.d_append(key, value).getResult();
    }

    public OperationResult<Long> d_append(final String key, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.APPEND){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.append(key, value);
            }
        });
    }

    public Long decr(String key) {
        return (Long)this.d_decr(key).getResult();
    }

    public OperationResult<Long> d_decr(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.DECR){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.decr(key);
            }
        });
    }

    public Long decrBy(String key, long delta) {
        return (Long)this.d_decrBy(key, delta).getResult();
    }

    public OperationResult<Long> d_decrBy(final String key, final Long delta) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.DECRBY){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.decrBy(key, delta.longValue());
            }
        });
    }

    public Long del(String key) {
        return (Long)this.d_del(key).getResult();
    }

    public OperationResult<Long> d_del(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.DEL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.del(key);
            }
        });
    }

    public byte[] dump(String key) {
        return (byte[])this.d_dump(key).getResult();
    }

    public OperationResult<byte[]> d_dump(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<byte[]>(key, OpName.DUMP){

            public byte[] execute(Jedis client, ConnectionContext state) {
                return client.dump(key);
            }
        });
    }

    public Boolean exists(String key) {
        return (Boolean)this.d_exists(key).getResult();
    }

    public OperationResult<Boolean> d_exists(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.EXISTS){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.exists(key);
            }
        });
    }

    public Long expire(String key, int seconds) {
        return (Long)this.d_expire(key, seconds).getResult();
    }

    public OperationResult<Long> d_expire(final String key, final int seconds) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.EXPIRE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.expire(key, seconds);
            }
        });
    }

    public Long expireAt(String key, long unixTime) {
        return (Long)this.d_expireAt(key, unixTime).getResult();
    }

    public OperationResult<Long> d_expireAt(final String key, final long unixTime) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.EXPIREAT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.expireAt(key, unixTime);
            }
        });
    }

    public Object eval(String script, int keyCount, String ... params) {
        return this.d_eval(script, keyCount, params).getResult();
    }

    public OperationResult<Object> d_eval(final String script, final int keyCount, final String ... params) {
        if (keyCount == 0) {
            throw new DynoException("Need at least one key in script");
        }
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Object>(params[0], OpName.EVAL){

            public Object execute(Jedis client, ConnectionContext state) {
                return client.eval(script, keyCount, params);
            }
        });
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        String[] params = (String[])ArrayUtils.addAll((Object[])keys.toArray(), (Object[])args.toArray());
        return this.eval(script, keys.size(), params);
    }

    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        throw new UnsupportedOperationException("This function is Not Implemented. Please use eval instead.");
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        throw new UnsupportedOperationException("This function is Not Implemented. Please use eval instead.");
    }

    public Object evalsha(String script) {
        throw new UnsupportedOperationException("This function is Not Implemented. Please use eval instead.");
    }

    public Boolean scriptExists(String sha1) {
        throw new UnsupportedOperationException("This function is Not Implemented");
    }

    public List<Boolean> scriptExists(String ... sha1) {
        throw new UnsupportedOperationException("This function is Not Implemented");
    }

    public String scriptLoad(String script) {
        throw new UnsupportedOperationException("This function is Not Implemented");
    }

    public String get(String key) {
        return (String)this.d_get(key).getResult();
    }

    public OperationResult<String> d_get(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.GET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.get(key);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.GET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return this.decompressValue(client.get(key), state);
            }
        });
    }

    public Boolean getbit(String key, long offset) {
        return (Boolean)this.d_getbit(key, offset).getResult();
    }

    public OperationResult<Boolean> d_getbit(final String key, final Long offset) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.GETBIT){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.getbit(key, offset.longValue());
            }
        });
    }

    public String getrange(String key, long startOffset, long endOffset) {
        return (String)this.d_getrange(key, startOffset, endOffset).getResult();
    }

    public OperationResult<String> d_getrange(final String key, final Long startOffset, final Long endOffset) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.GETRANGE){

            public String execute(Jedis client, ConnectionContext state) {
                return client.getrange(key, startOffset.longValue(), endOffset.longValue());
            }
        });
    }

    public String getSet(String key, String value) {
        return (String)this.d_getSet(key, value).getResult();
    }

    public OperationResult<String> d_getSet(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.GETSET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.getSet(key, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.GETSET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return this.decompressValue(client.getSet(key, this.compressValue(value, state)), state);
            }
        });
    }

    public Long hdel(String key, String ... fields) {
        return (Long)this.d_hdel(key, fields).getResult();
    }

    public OperationResult<Long> d_hdel(final String key, final String ... fields) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HDEL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hdel(key, fields);
            }
        });
    }

    public Boolean hexists(String key, String field) {
        return (Boolean)this.d_hexists(key, field).getResult();
    }

    public OperationResult<Boolean> d_hexists(final String key, final String field) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.HEXISTS){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.hexists(key, field);
            }
        });
    }

    public String hget(String key, String field) {
        return (String)this.d_hget(key, field).getResult();
    }

    public OperationResult<String> d_hget(final String key, final String field) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.HGET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.hget(key, field);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.HGET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return this.decompressValue(client.hget(key, field), state);
            }
        });
    }

    public Map<String, String> hgetAll(String key) {
        return (Map)this.d_hgetAll(key).getResult();
    }

    public OperationResult<Map<String, String>> d_hgetAll(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Map<String, String>>(key, OpName.HGETALL){

                public Map<String, String> execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.hgetAll(key);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Map<String, String>>(key, OpName.HGETALL){

            public Map<String, String> execute(Jedis client, final ConnectionContext state) {
                return CollectionUtils.transform((Map)client.hgetAll(key), (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<String, String, String>(){

                    public String get(String key, String val) {
                        return this.decompressValue(val, state);
                    }
                });
            }
        });
    }

    public Long hincrBy(String key, String field, long value) {
        return (Long)this.d_hincrBy(key, field, value).getResult();
    }

    public OperationResult<Long> d_hincrBy(final String key, final String field, final long value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HINCRBY){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hincrBy(key, field, value);
            }
        });
    }

    public Double hincrByFloat(String key, String field, double value) {
        return (Double)this.d_hincrByFloat(key, field, value).getResult();
    }

    public OperationResult<Double> d_hincrByFloat(final String key, final String field, final double value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.HINCRBYFLOAT){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.hincrByFloat(key, field, value);
            }
        });
    }

    public Long hsetnx(String key, String field, String value) {
        return (Long)this.d_hsetnx(key, field, value).getResult();
    }

    public OperationResult<Long> d_hsetnx(final String key, final String field, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HSETNX){

                public Long execute(Jedis client, ConnectionContext state) {
                    return client.hsetnx(key, field, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Long>(key, OpName.HSETNX){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.hsetnx(key, field, this.compressValue(value, state));
            }
        });
    }

    public Set<String> hkeys(String key) {
        return (Set)this.d_hkeys(key).getResult();
    }

    public OperationResult<Set<String>> d_hkeys(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.HKEYS){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.hkeys(key);
            }
        });
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        throw new UnsupportedOperationException("This function is deprecated, use hscan(String, String)");
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return (ScanResult)this.d_hscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<Map.Entry<String, String>>> d_hscan(final String key, final String cursor) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<Map.Entry<String, String>>>(key, OpName.HSCAN){

                public ScanResult<Map.Entry<String, String>> execute(Jedis client, ConnectionContext state) {
                    return client.hscan(key, cursor);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<ScanResult<Map.Entry<String, String>>>(key, OpName.HSCAN){

            public ScanResult<Map.Entry<String, String>> execute(Jedis client, final ConnectionContext state) {
                return new ScanResult(cursor, new ArrayList(CollectionUtils.transform((Collection)client.hscan(key, cursor).getResult(), (CollectionUtils.Transform)new CollectionUtils.Transform<Map.Entry<String, String>, Map.Entry<String, String>>(){

                    public Map.Entry<String, String> get(Map.Entry<String, String> entry) {
                        entry.setValue(this.decompressValue(entry.getValue(), state));
                        return entry;
                    }
                })));
            }
        });
    }

    private String getCursorValue(ConnectionContext state, CursorBasedResult cursor) {
        if (state != null && state.getMetadata("host") != null && cursor != null) {
            return cursor.getCursorForHost(state.getMetadata("host").toString());
        }
        return "0";
    }

    private List<OperationResult<ScanResult<String>>> scatterGatherScan(final CursorBasedResult<String> cursor, final int count, final String ... pattern) {
        return new ArrayList<OperationResult<ScanResult<String>>>(this.connPool.executeWithRing((Operation)new BaseKeyOperation<ScanResult<String>>("SCAN", OpName.SCAN){

            public ScanResult<String> execute(Jedis client, ConnectionContext state) throws DynoException {
                if (pattern != null && pattern.length > 0) {
                    ScanParams sp = new ScanParams().count(Integer.valueOf(count));
                    for (String s : pattern) {
                        sp.match(s);
                    }
                    return client.scan(DynoJedisClient.this.getCursorValue(state, cursor), sp);
                }
                return client.scan(DynoJedisClient.this.getCursorValue(state, cursor));
            }
        }));
    }

    public Long hlen(String key) {
        return (Long)this.d_hlen(key).getResult();
    }

    public OperationResult<Long> d_hlen(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hlen(key);
            }
        });
    }

    public List<String> hmget(String key, String ... fields) {
        return (List)this.d_hmget(key, fields).getResult();
    }

    public OperationResult<List<String>> d_hmget(final String key, final String ... fields) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.HMGET){

                public List<String> execute(Jedis client, ConnectionContext state) {
                    return client.hmget(key, fields);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<List<String>>(key, OpName.HMGET){

            public List<String> execute(Jedis client, final ConnectionContext state) throws DynoException {
                return new ArrayList<String>(CollectionUtils.transform((Collection)client.hmget(key, fields), (CollectionUtils.Transform)new CollectionUtils.Transform<String, String>(){

                    public String get(String s) {
                        return this.decompressValue(s, state);
                    }
                }));
            }
        });
    }

    public String hmset(String key, Map<String, String> hash) {
        return (String)this.d_hmset(key, hash).getResult();
    }

    public OperationResult<String> d_hmset(final String key, final Map<String, String> hash) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.HMSET){

                public String execute(Jedis client, ConnectionContext state) {
                    return client.hmset(key, hash);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.HMSET){

            public String execute(Jedis client, final ConnectionContext state) throws DynoException {
                return client.hmset(key, CollectionUtils.transform((Map)hash, (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<String, String, String>(){

                    public String get(String key, String val) {
                        return this.compressValue(val, state);
                    }
                }));
            }
        });
    }

    public Long hset(String key, String field, String value) {
        return (Long)this.d_hset(key, field, value).getResult();
    }

    public OperationResult<Long> d_hset(final String key, final String field, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HSET){

                public Long execute(Jedis client, ConnectionContext state) {
                    return client.hset(key, field, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Long>(key, OpName.HSET){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.hset(key, field, this.compressValue(value, state));
            }
        });
    }

    public List<String> hvals(String key) {
        return (List)this.d_hvals(key).getResult();
    }

    public OperationResult<List<String>> d_hvals(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.HVALS){

                public List<String> execute(Jedis client, ConnectionContext state) {
                    return client.hvals(key);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<List<String>>(key, OpName.HVALS){

            public List<String> execute(Jedis client, final ConnectionContext state) throws DynoException {
                return new ArrayList<String>(CollectionUtils.transform((Collection)client.hvals(key), (CollectionUtils.Transform)new CollectionUtils.Transform<String, String>(){

                    public String get(String s) {
                        return this.decompressValue(s, state);
                    }
                }));
            }
        });
    }

    public Long incr(String key) {
        return (Long)this.d_incr(key).getResult();
    }

    public OperationResult<Long> d_incr(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.INCR){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.incr(key);
            }
        });
    }

    public Long incrBy(String key, long delta) {
        return (Long)this.d_incrBy(key, delta).getResult();
    }

    public OperationResult<Long> d_incrBy(final String key, final Long delta) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.INCRBY){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.incrBy(key, delta.longValue());
            }
        });
    }

    public Double incrByFloat(String key, double increment) {
        return (Double)this.d_incrByFloat(key, increment).getResult();
    }

    public OperationResult<Double> d_incrByFloat(final String key, final Double increment) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.INCRBYFLOAT){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.incrByFloat(key, increment.doubleValue());
            }
        });
    }

    public String lindex(String key, long index) {
        return (String)this.d_lindex(key, index).getResult();
    }

    public OperationResult<String> d_lindex(final String key, final Long index) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LINDEX){

            public String execute(Jedis client, ConnectionContext state) {
                return client.lindex(key, index.longValue());
            }
        });
    }

    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        return (Long)this.d_linsert(key, where, pivot, value).getResult();
    }

    public OperationResult<Long> d_linsert(final String key, final BinaryClient.LIST_POSITION where, final String pivot, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LINSERT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.linsert(key, where, pivot, value);
            }
        });
    }

    public Long llen(String key) {
        return (Long)this.d_llen(key).getResult();
    }

    public OperationResult<Long> d_llen(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.llen(key);
            }
        });
    }

    public String lpop(String key) {
        return (String)this.d_lpop(key).getResult();
    }

    public OperationResult<String> d_lpop(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LPOP){

            public String execute(Jedis client, ConnectionContext state) {
                return client.lpop(key);
            }
        });
    }

    public Long lpush(String key, String ... values) {
        return (Long)this.d_lpush(key, values).getResult();
    }

    public OperationResult<Long> d_lpush(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LPUSH){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.lpush(key, values);
            }
        });
    }

    public Long lpushx(String key, String ... values) {
        return (Long)this.d_lpushx(key, values).getResult();
    }

    public OperationResult<Long> d_lpushx(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LPUSHX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.lpushx(key, values);
            }
        });
    }

    public List<String> lrange(String key, long start, long end) {
        return (List)this.d_lrange(key, start, end).getResult();
    }

    public OperationResult<List<String>> d_lrange(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.LRANGE){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.lrange(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long lrem(String key, long count, String value) {
        return (Long)this.d_lrem(key, count, value).getResult();
    }

    public OperationResult<Long> d_lrem(final String key, final Long count, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LREM){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.lrem(key, count.longValue(), value);
            }
        });
    }

    public String lset(String key, long index, String value) {
        return (String)this.d_lset(key, index, value).getResult();
    }

    public OperationResult<String> d_lset(final String key, final Long index, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LSET){

            public String execute(Jedis client, ConnectionContext state) {
                return client.lset(key, index.longValue(), value);
            }
        });
    }

    public String ltrim(String key, long start, long end) {
        return (String)this.d_ltrim(key, start, end).getResult();
    }

    public OperationResult<String> d_ltrim(final String key, final long start, final long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LTRIM){

            public String execute(Jedis client, ConnectionContext state) {
                return client.ltrim(key, start, end);
            }
        });
    }

    public Long persist(String key) {
        return (Long)this.d_persist(key).getResult();
    }

    public OperationResult<Long> d_persist(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.PERSIST){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.persist(key);
            }
        });
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        return (Long)this.d_pexpireAt(key, millisecondsTimestamp).getResult();
    }

    public OperationResult<Long> d_pexpireAt(final String key, final Long millisecondsTimestamp) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.PEXPIREAT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.pexpireAt(key, millisecondsTimestamp.longValue());
            }
        });
    }

    public Long pttl(String key) {
        return (Long)this.d_pttl(key).getResult();
    }

    public OperationResult<Long> d_pttl(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.PTTL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.pttl(key);
            }
        });
    }

    public String rename(String oldkey, String newkey) {
        return (String)this.d_rename(oldkey, newkey).getResult();
    }

    public OperationResult<String> d_rename(final String oldkey, final String newkey) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(oldkey, OpName.RENAME){

            public String execute(Jedis client, ConnectionContext state) {
                return client.rename(oldkey, newkey);
            }
        });
    }

    public Long renamenx(String oldkey, String newkey) {
        return (Long)this.d_renamenx(oldkey, newkey).getResult();
    }

    public OperationResult<Long> d_renamenx(final String oldkey, final String newkey) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(oldkey, OpName.RENAMENX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.renamenx(oldkey, newkey);
            }
        });
    }

    public String restore(String key, Integer ttl, byte[] serializedValue) {
        return (String)this.d_restore(key, ttl, serializedValue).getResult();
    }

    public OperationResult<String> d_restore(final String key, final Integer ttl, final byte[] serializedValue) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.RESTORE){

            public String execute(Jedis client, ConnectionContext state) {
                return client.restore(key, ttl.intValue(), serializedValue);
            }
        });
    }

    public String rpop(String key) {
        return (String)this.d_rpop(key).getResult();
    }

    public OperationResult<String> d_rpop(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.RPOP){

            public String execute(Jedis client, ConnectionContext state) {
                return client.rpop(key);
            }
        });
    }

    public String rpoplpush(String srckey, String dstkey) {
        return (String)this.d_rpoplpush(srckey, dstkey).getResult();
    }

    public OperationResult<String> d_rpoplpush(final String srckey, final String dstkey) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(srckey, OpName.RPOPLPUSH){

            public String execute(Jedis client, ConnectionContext state) {
                return client.rpoplpush(srckey, dstkey);
            }
        });
    }

    public Long rpush(String key, String ... values) {
        return (Long)this.d_rpush(key, values).getResult();
    }

    public OperationResult<Long> d_rpush(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.RPUSH){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.rpush(key, values);
            }
        });
    }

    public Long rpushx(String key, String ... values) {
        return (Long)this.d_rpushx(key, values).getResult();
    }

    public OperationResult<Long> d_rpushx(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.RPUSHX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.rpushx(key, values);
            }
        });
    }

    public Long sadd(String key, String ... members) {
        return (Long)this.d_sadd(key, members).getResult();
    }

    public OperationResult<Long> d_sadd(final String key, final String ... members) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.sadd(key, members);
            }
        });
    }

    public Long scard(String key) {
        return (Long)this.d_scard(key).getResult();
    }

    public OperationResult<Long> d_scard(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SCARD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.scard(key);
            }
        });
    }

    public Set<String> sdiff(String ... keys) {
        return (Set)this.d_sdiff(keys).getResult();
    }

    public OperationResult<Set<String>> d_sdiff(final String ... keys) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(keys[0], OpName.SDIFF){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.sdiff(keys);
            }
        });
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        return (Long)this.d_sdiffstore(dstkey, keys).getResult();
    }

    public OperationResult<Long> d_sdiffstore(final String dstkey, final String ... keys) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(dstkey, OpName.SDIFFSTORE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.sdiffstore(dstkey, keys);
            }
        });
    }

    public String set(String key, String value) {
        return (String)this.d_set(key, value).getResult();
    }

    public OperationResult<String> d_set(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.set(key, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.SET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.set(key, this.compressValue(value, state));
            }
        });
    }

    public String set(String key, String value, String nxxx, String expx, long time) {
        return (String)this.d_set(key, value, nxxx, expx, time).getResult();
    }

    public OperationResult<String> d_set(final String key, final String value, final String nxxx, final String expx, final long time) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.set(key, value, nxxx, expx, time);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.SET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.set(key, this.compressValue(value, state), nxxx, expx, time);
            }
        });
    }

    public Boolean setbit(String key, long offset, boolean value) {
        return (Boolean)this.d_setbit(key, (Long)offset, value).getResult();
    }

    public OperationResult<Boolean> d_setbit(final String key, final Long offset, final Boolean value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.SETBIT){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.setbit(key, offset.longValue(), value.booleanValue());
            }
        });
    }

    public Boolean setbit(String key, long offset, String value) {
        return (Boolean)this.d_setbit(key, (Long)offset, value).getResult();
    }

    public OperationResult<Boolean> d_setbit(final String key, final Long offset, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.SETBIT){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.setbit(key, offset.longValue(), value);
            }
        });
    }

    public String setex(String key, int seconds, String value) {
        return (String)this.d_setex(key, (Integer)seconds, value).getResult();
    }

    public OperationResult<String> d_setex(final String key, final Integer seconds, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SETEX){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.setex(key, seconds.intValue(), value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.SETEX){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.setex(key, seconds.intValue(), this.compressValue(value, state));
            }
        });
    }

    public Long setnx(String key, String value) {
        return (Long)this.d_setnx(key, value).getResult();
    }

    public OperationResult<Long> d_setnx(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SETNX){

                public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.setnx(key, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Long>(key, OpName.SETNX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.setnx(key, this.compressValue(value, state));
            }
        });
    }

    public Long setrange(String key, long offset, String value) {
        return (Long)this.d_setrange(key, offset, value).getResult();
    }

    public OperationResult<Long> d_setrange(final String key, final Long offset, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SETRANGE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.setrange(key, offset.longValue(), value);
            }
        });
    }

    public Boolean sismember(String key, String member) {
        return (Boolean)this.d_sismember(key, member).getResult();
    }

    public OperationResult<Boolean> d_sismember(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.SISMEMBER){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.sismember(key, member);
            }
        });
    }

    public Set<String> smembers(String key) {
        return (Set)this.d_smembers(key).getResult();
    }

    public OperationResult<Set<String>> d_smembers(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.SMEMBERS){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.smembers(key);
            }
        });
    }

    public Long smove(String srckey, String dstkey, String member) {
        return (Long)this.d_smove(srckey, dstkey, member).getResult();
    }

    public OperationResult<Long> d_smove(final String srckey, final String dstkey, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(srckey, OpName.SMOVE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.smove(srckey, dstkey, member);
            }
        });
    }

    public List<String> sort(String key) {
        return (List)this.d_sort(key).getResult();
    }

    public OperationResult<List<String>> d_sort(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.SORT){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.sort(key);
            }
        });
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        return (List)this.d_sort(key, sortingParameters).getResult();
    }

    public OperationResult<List<String>> d_sort(final String key, final SortingParams sortingParameters) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.SORT){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.sort(key, sortingParameters);
            }
        });
    }

    public String spop(String key) {
        return (String)this.d_spop(key).getResult();
    }

    public OperationResult<String> d_spop(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SPOP){

            public String execute(Jedis client, ConnectionContext state) {
                return client.spop(key);
            }
        });
    }

    public Set<String> spop(String key, long count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String srandmember(String key) {
        return (String)this.d_srandmember(key).getResult();
    }

    public List<String> srandmember(String key, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<String> d_srandmember(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SRANDMEMBER){

            public String execute(Jedis client, ConnectionContext state) {
                return client.srandmember(key);
            }
        });
    }

    public Long srem(String key, String ... members) {
        return (Long)this.d_srem(key, members).getResult();
    }

    public OperationResult<Long> d_srem(final String key, final String ... members) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SREM){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.srem(key, members);
            }
        });
    }

    public ScanResult<String> sscan(String key, int cursor) {
        return (ScanResult)this.d_sscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<String>> d_sscan(final String key, final int cursor) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<String>>(key, OpName.SSCAN){

            public ScanResult<String> execute(Jedis client, ConnectionContext state) {
                return client.sscan(key, cursor);
            }
        });
    }

    public ScanResult<String> sscan(String key, String cursor) {
        return (ScanResult)this.d_sscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<String>> d_sscan(final String key, final String cursor) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<String>>(key, OpName.SSCAN){

            public ScanResult<String> execute(Jedis client, ConnectionContext state) {
                return client.sscan(key, cursor);
            }
        });
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        return (ScanResult)this.d_sscan(key, cursor, params).getResult();
    }

    public OperationResult<ScanResult<String>> d_sscan(final String key, final String cursor, final ScanParams params) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<String>>(key, OpName.SSCAN){

            public ScanResult<String> execute(Jedis client, ConnectionContext state) {
                return client.sscan(key, cursor, params);
            }
        });
    }

    public Long strlen(String key) {
        return (Long)this.d_strlen(key).getResult();
    }

    public OperationResult<Long> d_strlen(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.STRLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.strlen(key);
            }
        });
    }

    public String substr(String key, int start, int end) {
        return (String)this.d_substr(key, start, end).getResult();
    }

    public OperationResult<String> d_substr(final String key, final Integer start, final Integer end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SUBSTR){

            public String execute(Jedis client, ConnectionContext state) {
                return client.substr(key, start.intValue(), end.intValue());
            }
        });
    }

    public Long ttl(String key) {
        return (Long)this.d_ttl(key).getResult();
    }

    public OperationResult<Long> d_ttl(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.TTL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.ttl(key);
            }
        });
    }

    public String type(String key) {
        return (String)this.d_type(key).getResult();
    }

    public OperationResult<String> d_type(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.TYPE){

            public String execute(Jedis client, ConnectionContext state) {
                return client.type(key);
            }
        });
    }

    public Long zadd(String key, double score, String member) {
        return (Long)this.d_zadd(key, score, member).getResult();
    }

    public OperationResult<Long> d_zadd(final String key, final Double score, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zadd(key, score.doubleValue(), member);
            }
        });
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        return (Long)this.d_zadd(key, scoreMembers).getResult();
    }

    public OperationResult<Long> d_zadd(final String key, final Map<String, Double> scoreMembers) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zadd(key, scoreMembers);
            }
        });
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        return (Long)this.d_zadd(key, score, member, params).getResult();
    }

    public OperationResult<Long> d_zadd(final String key, final double score, final String member, final ZAddParams params) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zadd(key, score, member, params);
            }
        });
    }

    public Long zcard(String key) {
        return (Long)this.d_zcard(key).getResult();
    }

    public OperationResult<Long> d_zcard(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZCARD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zcard(key);
            }
        });
    }

    public Long zcount(String key, double min, double max) {
        return (Long)this.d_zcount(key, min, max).getResult();
    }

    public OperationResult<Long> d_zcount(final String key, final Double min, final Double max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zcount(key, min.doubleValue(), max.doubleValue());
            }
        });
    }

    public Long zcount(String key, String min, String max) {
        return (Long)this.d_zcount(key, min, max).getResult();
    }

    public OperationResult<Long> d_zcount(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zcount(key, min, max);
            }
        });
    }

    public Double zincrby(String key, double score, String member) {
        return (Double)this.d_zincrby(key, score, member).getResult();
    }

    public OperationResult<Double> d_zincrby(final String key, final Double score, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.ZINCRBY){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.zincrby(key, score.doubleValue(), member);
            }
        });
    }

    public Set<String> zrange(String key, long start, long end) {
        return (Set)this.d_zrange(key, start, end).getResult();
    }

    public OperationResult<Set<String>> d_zrange(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrange(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long zrank(String key, String member) {
        return (Long)this.d_zrank(key, member).getResult();
    }

    public OperationResult<Long> d_zrank(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZRANK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zrank(key, member);
            }
        });
    }

    public Long zrem(String key, String ... member) {
        return (Long)this.d_zrem(key, member).getResult();
    }

    public OperationResult<Long> d_zrem(final String key, final String ... member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREM){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zrem(key, member);
            }
        });
    }

    public Long zremrangeByRank(String key, long start, long end) {
        return (Long)this.d_zremrangeByRank(key, start, end).getResult();
    }

    public OperationResult<Long> d_zremrangeByRank(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYRANK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByRank(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long zremrangeByScore(String key, double start, double end) {
        return (Long)this.d_zremrangeByScore(key, start, end).getResult();
    }

    public OperationResult<Long> d_zremrangeByScore(final String key, final Double start, final Double end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYSCORE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByScore(key, start.doubleValue(), end.doubleValue());
            }
        });
    }

    public Set<String> zrevrange(String key, long start, long end) {
        return (Set)this.d_zrevrange(key, start, end).getResult();
    }

    public OperationResult<Set<String>> d_zrevrange(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrange(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long zrevrank(String key, String member) {
        return (Long)this.d_zrevrank(key, member).getResult();
    }

    public OperationResult<Long> d_zrevrank(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREVRANK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zrevrank(key, member);
            }
        });
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        return (Set)this.d_zrangeWithScores(key, start, end).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeWithScores(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeWithScores(key, start.longValue(), end.longValue());
            }
        });
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        return (Set)this.d_zrevrangeWithScores(key, start, end).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeWithScores(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeWithScores(key, start.longValue(), end.longValue());
            }
        });
    }

    public Double zscore(String key, String member) {
        return (Double)this.d_zscore(key, member).getResult();
    }

    public OperationResult<Double> d_zscore(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.ZSCORE){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.zscore(key, member);
            }
        });
    }

    public ScanResult<Tuple> zscan(String key, int cursor) {
        return (ScanResult)this.d_zscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<Tuple>> d_zscan(final String key, final int cursor) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<Tuple>>(key, OpName.ZSCAN){

            public ScanResult<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zscan(key, cursor);
            }
        });
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        return (ScanResult)this.d_zscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<Tuple>> d_zscan(final String key, final String cursor) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<Tuple>>(key, OpName.ZSCAN){

            public ScanResult<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zscan(key, cursor);
            }
        });
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        return (Set)this.d_zrangeByScore(key, min, max).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final Double min, final Double max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min.doubleValue(), max.doubleValue());
            }
        });
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        return (Set)this.d_zrangeByScore(key, min, max).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min, max);
            }
        });
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return (Set)this.d_zrangeByScore(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final Double min, final Double max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min.doubleValue(), max.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        return (Set)this.d_zrevrangeByScore(key, max, min).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final String max, final String min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max, min);
            }
        });
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return (Set)this.d_zrangeByScore(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final String min, final String max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min, max, offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return (Set)this.d_zrevrangeByScore(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final Double max, final Double min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max.doubleValue(), min.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        return (Set)this.d_zrevrangeByScore(key, max, min).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final Double max, final Double min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max.doubleValue(), min.doubleValue());
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final Double min, final Double max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min.doubleValue(), max.doubleValue());
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, min, max).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final Double max, final Double min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max.doubleValue(), min.doubleValue());
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final Double min, final Double max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min.doubleValue(), max.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return (Set)this.d_zrevrangeByScore(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final String max, final String min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max, min, offset.intValue(), count.intValue());
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min, max);
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, max, min).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final String max, final String min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max, min);
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final String min, final String max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min, max, offset.intValue(), count.intValue());
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final Double max, final Double min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max.doubleValue(), min.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final String max, final String min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max, min, offset.intValue(), count.intValue());
            }
        });
    }

    public Long zremrangeByScore(String key, String start, String end) {
        return (Long)this.d_zremrangeByScore(key, start, end).getResult();
    }

    public Long zlexcount(String key, String min, String max) {
        return (Long)this.d_zlexcount(key, min, max).getResult();
    }

    public OperationResult<Long> d_zlexcount(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZLEXCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zlexcount(key, min, max);
            }
        });
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        return (Set)this.d_zrangeByLex(key, min, max).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByLex(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, min, max);
            }
        });
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        return (Set)this.d_zrangeByLex(key, min, max, offset, count).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByLex(final String key, final String min, final String max, final int offset, final int count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, min, max, offset, count);
            }
        });
    }

    public Long zremrangeByLex(String key, String min, String max) {
        return (Long)this.d_zremrangeByLex(key, min, max).getResult();
    }

    public OperationResult<Long> d_zremrangeByLex(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYLEX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByLex(key, min, max);
            }
        });
    }

    public OperationResult<Long> d_zremrangeByScore(final String key, final String start, final String end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYSCORE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByScore(key, start, end);
            }
        });
    }

    public List<String> blpop(String arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> blpop(int timeout, String key) {
        return (List)this.d_blpop(timeout, key).getResult();
    }

    public OperationResult<List<String>> d_blpop(final int timeout, final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.BLPOP){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.blpop(timeout, key);
            }
        });
    }

    public List<String> brpop(String arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> brpop(int timeout, String key) {
        return (List)this.d_brpop(timeout, key).getResult();
    }

    public OperationResult<List<String>> d_brpop(final int timeout, final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.BRPOP){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.brpop(timeout, key);
            }
        });
    }

    public String echo(String string) {
        return (String)this.d_echo(string).getResult();
    }

    public OperationResult<String> d_echo(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.ECHO){

            public String execute(Jedis client, ConnectionContext state) {
                return client.echo(key);
            }
        });
    }

    public Long move(String key, int dbIndex) {
        return (Long)this.d_move(key, dbIndex).getResult();
    }

    public OperationResult<Long> d_move(final String key, final Integer dbIndex) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.MOVE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.move(key, dbIndex.intValue());
            }
        });
    }

    public Long bitcount(String key) {
        return (Long)this.d_bitcount(key).getResult();
    }

    public OperationResult<Long> d_bitcount(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.BITCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.bitcount(key);
            }
        });
    }

    public Long bitcount(String key, long start, long end) {
        return (Long)this.d_bitcount(key, start, end).getResult();
    }

    public Long pfadd(String key, String ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long pfcount(String key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<Long> d_bitcount(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.BITCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.bitcount(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long del(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> blpop(int timeout, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> brpop(int timeout, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> blpop(String ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> brpop(String ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<String> keys(String pattern) {
        HashSet<String> allResults = new HashSet<String>();
        Collection<OperationResult<Set<String>>> results = this.d_keys(pattern);
        for (OperationResult<Set<String>> result : results) {
            allResults.addAll((Collection)result.getResult());
        }
        return allResults;
    }

    public Collection<OperationResult<Set<String>>> d_keys(final String pattern) {
        Logger.warn("Executing d_keys for pattern: " + pattern);
        Collection results = this.connPool.executeWithRing((Operation)new BaseKeyOperation<Set<String>>(pattern, OpName.KEYS){

            public Set<String> execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.keys(pattern);
            }
        });
        return results;
    }

    public Long pexpire(String key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> mget(String ... keys) {
        return (List)this.d_mget(keys).getResult();
    }

    public OperationResult<List<String>> d_mget(final String ... keys) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new MultiKeyOperation<List<String>>(Arrays.asList(keys), OpName.MGET){

                public List<String> execute(Jedis client, ConnectionContext state) {
                    return client.mget(keys);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueMultiKeyOperation<List<String>>(Arrays.asList(keys), OpName.MGET){

            public List<String> execute(Jedis client, final ConnectionContext state) throws DynoException {
                return new ArrayList<String>(CollectionUtils.transform((Collection)client.mget(keys), (CollectionUtils.Transform)new CollectionUtils.Transform<String, String>(){

                    public String get(String s) {
                        return this.decompressValue(s, state);
                    }
                }));
            }
        });
    }

    public String mset(String ... keysvalues) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long msetnx(String ... keysvalues) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<String> sinter(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sinterstore(String dstkey, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sort(String key, String dstkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<String> sunion(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sunionstore(String dstkey, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String watch(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String unwatch() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zinterstore(String dstkey, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        return (Set)this.d_zrevrangeByLex(key, max, min).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByLex(final String key, final String max, final String min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, max, min);
            }
        });
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return (Set)this.d_zrevrangeByLex(key, max, min, offset, count).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByLex(final String key, final String max, final String min, final int offset, final int count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, max, min, offset, count);
            }
        });
    }

    public Long zunionstore(String dstkey, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String brpoplpush(String source, String destination, int timeout) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long publish(String channel, String message) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String randomKey() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String set(byte[] key, byte[] value) {
        return (String)this.d_set(key, value).getResult();
    }

    public OperationResult<String> d_set(final byte[] key, final byte[] value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.set(key, value);
            }
        });
    }

    public byte[] get(byte[] key) {
        return (byte[])this.d_get(key).getResult();
    }

    public OperationResult<byte[]> d_get(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<byte[]>(key, OpName.GET){

            public byte[] execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.get(key);
            }
        });
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        return (String)this.d_setex(key, (Integer)seconds, value).getResult();
    }

    public OperationResult<String> d_setex(final byte[] key, final Integer seconds, final byte[] value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SETEX){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.setex(key, seconds.intValue(), value);
            }
        });
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean exists(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long persist(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String type(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long expire(byte[] key, int seconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long pexpire(byte[] key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long expireAt(byte[] key, long unixTime) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long ttl(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean setbit(byte[] key, long offset, boolean value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean getbit(byte[] key, long offset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] getSet(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long setnx(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long decrBy(byte[] key, long integer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long decr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long incrBy(byte[] key, long integer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double incrByFloat(byte[] key, double value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long incr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long append(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] substr(byte[] key, int start, int end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] hget(byte[] key, byte[] field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean hexists(byte[] key, byte[] field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hdel(byte[] key, byte[] ... field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hlen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> hkeys(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Collection<byte[]> hvals(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long rpush(byte[] key, byte[] ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long lpush(byte[] key, byte[] ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long llen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String ltrim(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] lindex(byte[] key, long index) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String lset(byte[] key, long index, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long lrem(byte[] key, long count, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] lpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] rpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sadd(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> smembers(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long srem(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] spop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> spop(byte[] key, long count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long scard(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean sismember(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] srandmember(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long strlen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zrem(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zrevrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zcard(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double zscore(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> sort(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zcount(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByRank(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long lpushx(byte[] key, byte[] ... arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long rpushx(byte[] key, byte[] ... arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> blpop(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> brpop(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long del(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] echo(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitcount(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long pfadd(byte[] key, byte[] ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long pfcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<String> scan(int cursor) {
        throw new UnsupportedOperationException("Not supported - use dyno_scan(String, CursorBasedResult");
    }

    public ScanResult<String> scan(String cursor) {
        throw new UnsupportedOperationException("Not supported - use dyno_scan(String, CursorBasedResult");
    }

    public CursorBasedResult<String> dyno_scan(String ... pattern) {
        return this.dyno_scan(10, pattern);
    }

    public CursorBasedResult<String> dyno_scan(int count, String ... pattern) {
        return this.dyno_scan(null, count, pattern);
    }

    public CursorBasedResult<String> dyno_scan(CursorBasedResult<String> cursor, int count, String ... pattern) {
        LinkedHashMap results = new LinkedHashMap();
        List<OperationResult<ScanResult<String>>> opResults = this.scatterGatherScan(cursor, count, pattern);
        for (OperationResult<ScanResult<String>> opResult : opResults) {
            results.put(opResult.getNode().getHostAddress(), opResult.getResult());
        }
        return new CursorBasedResultImpl<String>(results);
    }

    public String pfmerge(String destkey, String ... sourcekeys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long pfcount(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void stopClient() {
        if (this.pipelineMonitor.get() != null) {
            this.pipelineMonitor.get().stop();
        }
        this.connPool.shutdown();
    }

    public DynoJedisPipeline pipelined() {
        return new DynoJedisPipeline(this.getConnPool(), this.checkAndInitPipelineMonitor(), this.getConnPool().getMonitor());
    }

    private DynoJedisPipelineMonitor checkAndInitPipelineMonitor() {
        if (this.pipelineMonitor.get() != null) {
            return this.pipelineMonitor.get();
        }
        int flushTimerFrequency = this.connPool.getConfiguration().getTimingCountersResetFrequencySeconds();
        DynoJedisPipelineMonitor plMonitor = new DynoJedisPipelineMonitor(this.appName, flushTimerFrequency);
        boolean success = this.pipelineMonitor.compareAndSet(null, plMonitor);
        if (success) {
            this.pipelineMonitor.get().init();
        }
        return this.pipelineMonitor.get();
    }

    public Long exists(String ... arg0) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<String> scan(String arg0, ScanParams arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(byte[] arg0, Map<byte[], GeoCoordinate> arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(byte[] arg0, double arg1, double arg2, byte[] arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(byte[] arg0, byte[] arg1, byte[] arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(byte[] arg0, byte[] arg1, byte[] arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> geohash(byte[] arg0, byte[] ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoCoordinate> geopos(byte[] arg0, byte[] ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(byte[] arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(byte[] arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] arg0, byte[] arg1, double arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] arg0, byte[] arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] arg0, byte[] arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String set(byte[] arg0, byte[] arg1, byte[] arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<byte[]> sscan(byte[] arg0, byte[] arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<byte[]> sscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(byte[] arg0, Map<byte[], Double> arg1, ZAddParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(byte[] arg0, double arg1, byte[] arg2, ZAddParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double zincrby(byte[] arg0, double arg1, byte[] arg2, ZIncrByParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Tuple> zscan(byte[] arg0, byte[] arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Tuple> zscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> bitfield(byte[] key, byte[] ... arguments) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitpos(String arg0, boolean arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitpos(String arg0, boolean arg1, BitPosParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(String arg0, Map<String, GeoCoordinate> arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(String arg0, double arg1, double arg2, String arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(String arg0, String arg1, String arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> geohash(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoCoordinate> geopos(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<Long> bitfield(String key, String ... arguments) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Map.Entry<String, String>> hscan(String arg0, String arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String psetex(String arg0, long arg1, String arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String set(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(String arg0, Map<String, Double> arg1, ZAddParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double zincrby(String arg0, double arg1, String arg2, ZIncrByParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Tuple> zscan(String arg0, String arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    static class TestBuilder {
        private ConnectionPool cp;
        private String appName;

        TestBuilder() {
        }

        public TestBuilder withAppname(String appName) {
            this.appName = appName;
            return this;
        }

        public TestBuilder withConnectionPool(ConnectionPool cp) {
            this.cp = cp;
            return this;
        }

        public DynoJedisClient build() {
            return new DynoJedisClient(this.appName, "TestCluster", (ConnectionPool<Jedis>)this.cp, null, null);
        }
    }

    public static class Builder {
        private String appName;
        private String clusterName;
        private ConnectionPoolConfigurationImpl cpConfig;
        private HostSupplier hostSupplier;
        private EurekaClient discoveryClient;
        private String dualWriteClusterName;
        private HostSupplier dualWriteHostSupplier;
        private DynoDualWriterClient.Dial dualWriteDial;
        private ConnectionPoolMonitor cpMonitor;
        private SSLSocketFactory sslSocketFactory;

        public Builder withApplicationName(String applicationName) {
            this.appName = applicationName;
            return this;
        }

        public Builder withDynomiteClusterName(String cluster) {
            this.clusterName = cluster;
            return this;
        }

        public Builder withCPConfig(ConnectionPoolConfigurationImpl config) {
            this.cpConfig = config;
            return this;
        }

        public Builder withHostSupplier(HostSupplier hSupplier) {
            this.hostSupplier = hSupplier;
            return this;
        }

        @Deprecated
        public Builder withDiscoveryClient(DiscoveryClient client) {
            this.discoveryClient = client;
            return this;
        }

        public Builder withDiscoveryClient(EurekaClient client) {
            this.discoveryClient = client;
            return this;
        }

        public Builder withDualWriteClusterName(String dualWriteCluster) {
            this.dualWriteClusterName = dualWriteCluster;
            return this;
        }

        public Builder withDualWriteHostSupplier(HostSupplier dualWriteHostSupplier) {
            this.dualWriteHostSupplier = dualWriteHostSupplier;
            return this;
        }

        public Builder withDualWriteDial(DynoDualWriterClient.Dial dial) {
            this.dualWriteDial = dial;
            return this;
        }

        public Builder withConnectionPoolMonitor(ConnectionPoolMonitor cpMonitor) {
            this.cpMonitor = cpMonitor;
            return this;
        }

        public Builder withSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public DynoJedisClient build() {
            assert (this.appName != null);
            assert (this.clusterName != null);
            if (this.cpConfig == null) {
                this.cpConfig = new ArchaiusConnectionPoolConfiguration(this.appName);
                Logger.info("Dyno Client runtime properties: " + this.cpConfig.toString());
            }
            if (this.cpConfig.isDualWriteEnabled()) {
                return this.buildDynoDualWriterClient();
            }
            return this.buildDynoJedisClient();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private DynoDualWriterClient buildDynoDualWriterClient() {
            ConnectionPoolConfigurationImpl shadowConfig = new ConnectionPoolConfigurationImpl(this.cpConfig);
            Logger.info("Dyno Client Shadow Config runtime properties: " + shadowConfig.toString());
            shadowConfig.setFailOnStartupIfNoHosts(false);
            HostSupplier shadowSupplier = null;
            if (this.dualWriteHostSupplier == null) {
                if (this.hostSupplier != null && this.hostSupplier instanceof EurekaHostsSupplier) {
                    EurekaHostsSupplier eurekaSupplier = (EurekaHostsSupplier)this.hostSupplier;
                    shadowSupplier = EurekaHostsSupplier.newInstance((String)shadowConfig.getDualWriteClusterName(), (EurekaHostsSupplier)eurekaSupplier);
                } else {
                    if (this.discoveryClient == null) throw new DynoConnectException("HostSupplier for DualWrite cluster is REQUIRED if you are not using EurekaHostsSupplier implementation or using a EurekaClient");
                    shadowSupplier = new EurekaHostsSupplier(shadowConfig.getDualWriteClusterName(), this.discoveryClient);
                }
            } else {
                shadowSupplier = this.dualWriteHostSupplier;
            }
            shadowConfig.withHostSupplier(shadowSupplier);
            this.setLoadBalancingStrategy(shadowConfig);
            this.setHashtagConnectionPool(shadowSupplier, shadowConfig);
            String shadowAppName = shadowConfig.getName();
            DynoCPMonitor shadowCPMonitor = new DynoCPMonitor(shadowAppName);
            DynoOPMonitor shadowOPMonitor = new DynoOPMonitor(shadowAppName);
            JedisConnectionFactory connFactory = new JedisConnectionFactory((OperationMonitor)shadowOPMonitor, this.sslSocketFactory);
            ConnectionPoolImpl<Jedis> shadowPool = this.startConnectionPool(shadowAppName, connFactory, shadowConfig, (ConnectionPoolMonitor)shadowCPMonitor);
            DynoJedisClient shadowClient = new DynoJedisClient(shadowAppName, this.dualWriteClusterName, (ConnectionPool<Jedis>)shadowPool, shadowOPMonitor, (ConnectionPoolMonitor)shadowCPMonitor);
            DynoOPMonitor opMonitor = new DynoOPMonitor(this.appName);
            DynoCPMonitor cpMonitor = this.cpMonitor == null ? new DynoCPMonitor(this.appName) : this.cpMonitor;
            ConnectionPoolImpl<Jedis> pool = this.createConnectionPool(this.appName, opMonitor, (ConnectionPoolMonitor)cpMonitor);
            if (this.dualWriteDial == null) return new DynoDualWriterClient(this.appName, this.clusterName, (ConnectionPool<Jedis>)pool, opMonitor, (ConnectionPoolMonitor)cpMonitor, shadowClient);
            if (shadowConfig.getDualWritePercentage() <= 0) return new DynoDualWriterClient(this.appName, this.clusterName, (ConnectionPool<Jedis>)pool, opMonitor, (ConnectionPoolMonitor)cpMonitor, shadowClient, this.dualWriteDial);
            this.dualWriteDial.setRange(shadowConfig.getDualWritePercentage());
            return new DynoDualWriterClient(this.appName, this.clusterName, (ConnectionPool<Jedis>)pool, opMonitor, (ConnectionPoolMonitor)cpMonitor, shadowClient, this.dualWriteDial);
        }

        private DynoJedisClient buildDynoJedisClient() {
            DynoOPMonitor opMonitor = new DynoOPMonitor(this.appName);
            DynoCPMonitor cpMonitor = this.cpMonitor == null ? new DynoCPMonitor(this.appName) : this.cpMonitor;
            ConnectionPoolImpl<Jedis> pool = this.createConnectionPool(this.appName, opMonitor, (ConnectionPoolMonitor)cpMonitor);
            return new DynoJedisClient(this.appName, this.clusterName, (ConnectionPool<Jedis>)pool, opMonitor, (ConnectionPoolMonitor)cpMonitor);
        }

        private ConnectionPoolImpl<Jedis> createConnectionPool(String appName, DynoOPMonitor opMonitor, ConnectionPoolMonitor cpMonitor) {
            if (this.hostSupplier == null) {
                if (this.discoveryClient == null) {
                    throw new DynoConnectException("HostSupplier not provided. Cannot initialize EurekaHostsSupplier which requires a DiscoveryClient");
                }
                this.hostSupplier = new EurekaHostsSupplier(this.clusterName, this.discoveryClient);
            }
            this.cpConfig.withHostSupplier(this.hostSupplier);
            this.setLoadBalancingStrategy(this.cpConfig);
            this.setHashtagConnectionPool(this.hostSupplier, this.cpConfig);
            JedisConnectionFactory connFactory = new JedisConnectionFactory((OperationMonitor)opMonitor, this.sslSocketFactory);
            return this.startConnectionPool(appName, connFactory, this.cpConfig, cpMonitor);
        }

        private ConnectionPoolImpl<Jedis> startConnectionPool(String appName, JedisConnectionFactory connFactory, ConnectionPoolConfigurationImpl cpConfig, ConnectionPoolMonitor cpMonitor) {
            final ConnectionPoolImpl pool = new ConnectionPoolImpl((ConnectionFactory)connFactory, (ConnectionPoolConfiguration)cpConfig, cpMonitor);
            try {
                Logger.info("Starting connection pool for app " + appName);
                pool.start().get();
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        pool.shutdown();
                    }
                }));
            }
            catch (NoAvailableHostsException e) {
                if (cpConfig.getFailOnStartupIfNoHosts()) {
                    throw new RuntimeException(e);
                }
                Logger.warn("UNABLE TO START CONNECTION POOL -- IDLING");
                pool.idle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return pool;
        }

        private void setLoadBalancingStrategy(ConnectionPoolConfigurationImpl config) {
            if (ConnectionPoolConfiguration.LoadBalancingStrategy.TokenAware == config.getLoadBalancingStrategy()) {
                if (config.getTokenSupplier() == null) {
                    Logger.warn("TOKEN AWARE selected and no token supplier found, using default HttpEndpointBasedTokenMapSupplier()");
                    config.withTokenSupplier((TokenMapSupplier)new HttpEndpointBasedTokenMapSupplier());
                }
                if (config.getLocalRack() == null && config.localZoneAffinity()) {
                    String warningMessage = "DynoJedisClient for app=[" + config.getName() + "] is configured for local rack affinity but cannot determine the local rack! DISABLING rack affinity for this instance. To make the client aware of the local rack either use ConnectionPoolConfigurationImpl.setLocalRack() when constructing the client instance or ensure EC2_AVAILABILTY_ZONE is set as an environment variable, e.g. run with -DEC2_AVAILABILITY_ZONE=us-east-1c";
                    config.setLocalZoneAffinity(false);
                    Logger.warn(warningMessage);
                }
            }
        }

        private void setHashtagConnectionPool(HostSupplier hostSupplier, ConnectionPoolConfigurationImpl config) {
            List hostTokens;
            Collection hosts = hostSupplier.getHosts();
            ArrayList arrayHosts = new ArrayList(hosts);
            Collections.sort(arrayHosts);
            HashSet hostSet = new HashSet(arrayHosts);
            TokenMapSupplier tokenMapSupplier = config.getTokenSupplier();
            if (tokenMapSupplier != null) {
                hostTokens = tokenMapSupplier.getTokens(hostSet);
                if (hostTokens.isEmpty()) {
                    throw new DynoConnectException("No hosts in the TokenMapSupplier");
                }
            } else {
                throw new DynoConnectException("TokenMapSupplier not provided");
            }
            String hashtag = ((HostToken)hostTokens.get(0)).getHost().getHashtag();
            int numHosts = 0;
            for (HostToken hToken : hostTokens) {
                String hashtagNew = hToken.getHost().getHashtag();
                if (hashtag != null && !hashtag.equals(hashtagNew)) {
                    Logger.error("Hashtag mismatch across hosts");
                    throw new RuntimeException("Hashtags are different across hosts");
                }
                if (numHosts > 0 && hashtag == null && hashtagNew != null) {
                    Logger.error("Hashtag mismatch across hosts");
                    throw new RuntimeException("Hashtags are different across hosts");
                }
                hashtag = hashtagNew;
                numHosts = (short)(numHosts + 1);
            }
            if (hashtag != null) {
                config.withHashtag(hashtag);
            }
        }
    }

    private abstract class CompressionValueMultiKeyOperation<T>
    extends MultiKeyOperation<T>
    implements CompressionOperation<Jedis, T> {
        private CompressionValueMultiKeyOperation(List<String> keys, OpName o) {
            super(keys, o);
        }

        public String compressValue(String value, ConnectionContext ctx) {
            String result = value;
            int thresholdBytes = DynoJedisClient.this.connPool.getConfiguration().getValueCompressionThreshold();
            try {
                if (2 * value.length() > thresholdBytes) {
                    result = ZipUtils.compressStringToBase64String((String)value);
                    ctx.setMetadata("compression", (Object)true);
                }
            }
            catch (IOException e) {
                Logger.warn("UNABLE to compress [" + value + "] for key [" + this.getKey() + "]; sending value uncompressed");
            }
            return result;
        }

        public String decompressValue(String value, ConnectionContext ctx) {
            try {
                if (ZipUtils.isCompressed((String)value)) {
                    ctx.setMetadata("decompression", (Object)true);
                    return ZipUtils.decompressFromBase64String((String)value);
                }
            }
            catch (IOException e) {
                Logger.warn("Unable to decompress value [" + value + "]");
            }
            return value;
        }
    }

    private abstract class CompressionValueOperation<T>
    extends BaseKeyOperation<T>
    implements CompressionOperation<Jedis, T> {
        private CompressionValueOperation(String k, OpName o) {
            super(k, o);
        }

        public String compressValue(String value, ConnectionContext ctx) {
            String result = value;
            int thresholdBytes = DynoJedisClient.this.connPool.getConfiguration().getValueCompressionThreshold();
            try {
                if (2 * value.length() > thresholdBytes) {
                    result = ZipUtils.compressStringToBase64String((String)value);
                    ctx.setMetadata("compression", (Object)true);
                }
            }
            catch (IOException e) {
                Logger.warn("UNABLE to compress [" + value + "] for key [" + this.getKey() + "]; sending value uncompressed");
            }
            return result;
        }

        public String decompressValue(String value, ConnectionContext ctx) {
            try {
                if (ZipUtils.isCompressed((String)value)) {
                    ctx.setMetadata("decompression", (Object)true);
                    return ZipUtils.decompressFromBase64String((String)value);
                }
            }
            catch (IOException e) {
                Logger.warn("Unable to decompress value [" + value + "]");
            }
            return value;
        }
    }

    private abstract class MultiKeyOperation<T>
    implements Operation<Jedis, T> {
        private final List<String> keys;
        private final List<byte[]> binaryKeys;
        private final OpName op;

        private MultiKeyOperation(List<String> keys, OpName o) {
            this.keys = keys;
            this.binaryKeys = null;
            this.op = o;
        }

        public String getName() {
            return this.op.name();
        }

        public String getKey() {
            return this.keys.get(0);
        }

        public byte[] getBinaryKey() {
            return this.binaryKeys.get(0);
        }
    }

    private abstract class BaseKeyOperation<T>
    implements Operation<Jedis, T> {
        private final String key;
        private final byte[] binaryKey;
        private final OpName op;

        private BaseKeyOperation(String k, OpName o) {
            this.key = k;
            this.binaryKey = null;
            this.op = o;
        }

        private BaseKeyOperation(byte[] k, OpName o) {
            this.key = null;
            this.binaryKey = null;
            this.op = o;
        }

        public String getName() {
            return this.op.name();
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getBinaryKey() {
            return this.binaryKey;
        }
    }
}

