/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.dyno.connectionpool.CursorBasedResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.ScanResult;

public class CursorBasedResultImpl<T>
implements CursorBasedResult<T> {
    private final Map<String, ScanResult<T>> result;

    public CursorBasedResultImpl(Map<String, ScanResult<T>> result) {
        this.result = result;
    }

    public List<T> getResult() {
        ArrayList aggregated = new ArrayList();
        for (ScanResult<T> sr : this.result.values()) {
            aggregated.addAll(sr.getResult());
        }
        return aggregated;
    }

    public List<String> getStringResult() {
        ArrayList<String> aggregated = new ArrayList<String>();
        for (Map.Entry<String, ScanResult<T>> entry : this.result.entrySet()) {
            aggregated.add(String.format("%s -> %s", entry.getKey(), entry.getValue().getStringCursor()));
        }
        return aggregated;
    }

    public String getCursorForHost(String host) {
        ScanResult<T> sr = this.result.get(host);
        if (sr != null) {
            return sr.getStringCursor();
        }
        return "0";
    }

    public boolean isComplete() {
        for (ScanResult<T> r : this.result.values()) {
            if (r.getStringCursor().equals("0")) continue;
            return false;
        }
        return true;
    }
}

