/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.dyno.connectionpool.BaseOperation;
import com.netflix.dyno.connectionpool.Connection;
import com.netflix.dyno.connectionpool.ConnectionPoolConfiguration;
import com.netflix.dyno.connectionpool.ConnectionPoolMonitor;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.exception.DynoConnectException;
import com.netflix.dyno.connectionpool.exception.DynoException;
import com.netflix.dyno.connectionpool.exception.FatalConnectionException;
import com.netflix.dyno.connectionpool.exception.NoAvailableHostsException;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolImpl;
import com.netflix.dyno.connectionpool.impl.utils.CollectionUtils;
import com.netflix.dyno.connectionpool.impl.utils.ZipUtils;
import com.netflix.dyno.jedis.DynoJedisPipelineMonitor;
import com.netflix.dyno.jedis.JedisConnectionFactory;
import com.netflix.dyno.jedis.OpName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryRedisPipeline;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.RedisPipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

@NotThreadSafe
public class DynoJedisPipeline
implements RedisPipeline,
BinaryRedisPipeline,
AutoCloseable {
    private static final Logger Logger = LoggerFactory.getLogger(DynoJedisPipeline.class);
    private final ConnectionPoolImpl<Jedis> connPool;
    private volatile Connection<Jedis> connection;
    private final DynoJedisPipelineMonitor opMonitor;
    private final ConnectionPoolMonitor cpMonitor;
    private volatile Pipeline jedisPipeline = null;
    private final AtomicReference<String> theKey = new AtomicReference<Object>(null);
    private final AtomicReference<byte[]> theBinaryKey = new AtomicReference<Object>(null);
    private final AtomicReference<String> hashtag = new AtomicReference<Object>(null);
    private final AtomicReference<DynoException> pipelineEx = new AtomicReference<Object>(null);
    private static final String DynoPipeline = "DynoPipeline";

    DynoJedisPipeline(ConnectionPoolImpl<Jedis> cPool, DynoJedisPipelineMonitor operationMonitor, ConnectionPoolMonitor connPoolMonitor) {
        this.connPool = cPool;
        this.opMonitor = operationMonitor;
        this.cpMonitor = connPoolMonitor;
    }

    private void pipelined(final byte[] key) {
        try {
            try {
                this.connection = this.connPool.getConnectionForOperation((BaseOperation)new BaseOperation<Jedis, String>(){

                    public String getName() {
                        return DynoJedisPipeline.DynoPipeline;
                    }

                    public String getStringKey() {
                        return null;
                    }

                    public byte[] getBinaryKey() {
                        return key;
                    }
                });
            }
            catch (NoAvailableHostsException nahe) {
                this.cpMonitor.incOperationFailure(this.connection != null ? this.connection.getHost() : null, (Exception)((Object)nahe));
                this.discardPipelineAndReleaseConnection();
                throw nahe;
            }
        }
        catch (NoAvailableHostsException nahe) {
            this.cpMonitor.incOperationFailure(this.connection != null ? this.connection.getHost() : null, (Exception)((Object)nahe));
            this.discardPipelineAndReleaseConnection();
            throw nahe;
        }
        Jedis jedis = ((JedisConnectionFactory.JedisConnection)this.connection).getClient();
        this.jedisPipeline = jedis.pipelined();
        this.cpMonitor.incOperationSuccess(this.connection.getHost(), 0L);
    }

    private void pipelined(final String key) {
        try {
            try {
                this.connection = this.connPool.getConnectionForOperation((BaseOperation)new BaseOperation<Jedis, String>(){

                    public String getName() {
                        return DynoJedisPipeline.DynoPipeline;
                    }

                    public String getStringKey() {
                        return key;
                    }

                    public byte[] getBinaryKey() {
                        return null;
                    }
                });
            }
            catch (NoAvailableHostsException nahe) {
                this.cpMonitor.incOperationFailure(this.connection != null ? this.connection.getHost() : null, (Exception)((Object)nahe));
                this.discardPipelineAndReleaseConnection();
                throw nahe;
            }
        }
        catch (NoAvailableHostsException nahe) {
            this.cpMonitor.incOperationFailure(this.connection != null ? this.connection.getHost() : null, (Exception)((Object)nahe));
            this.discardPipelineAndReleaseConnection();
            throw nahe;
        }
        Jedis jedis = ((JedisConnectionFactory.JedisConnection)this.connection).getClient();
        this.jedisPipeline = jedis.pipelined();
        this.cpMonitor.incOperationSuccess(this.connection.getHost(), 0L);
    }

    private void checkHashtag(String key, String hashtagValue) {
        if (this.hashtag.get() != null) {
            this.verifyHashtagValue(hashtagValue);
        } else {
            boolean success = this.hashtag.compareAndSet(null, hashtagValue);
            if (!success) {
                this.verifyHashtagValue(hashtagValue);
            } else {
                this.pipelined(key);
            }
        }
    }

    private void checkKey(byte[] key) {
        if (this.theBinaryKey.get() != null) {
            this.verifyKey(key);
        } else {
            boolean success = this.theBinaryKey.compareAndSet(null, key);
            if (!success) {
                this.verifyKey(key);
            } else {
                this.pipelined(key);
            }
        }
    }

    private void checkKey(String key) {
        String hashtag = this.connPool.getConfiguration().getHashtag();
        if (hashtag == null || hashtag.isEmpty()) {
            if (this.theKey.get() != null) {
                this.verifyKey(key);
            } else {
                boolean success = this.theKey.compareAndSet(null, key);
                if (!success) {
                    this.verifyKey(key);
                } else {
                    this.pipelined(key);
                }
            }
        } else {
            String hashValue = StringUtils.substringBetween((String)key, (String)Character.toString(hashtag.charAt(0)), (String)Character.toString(hashtag.charAt(1)));
            this.checkHashtag(key, hashValue);
        }
    }

    private void verifyKey(byte[] key) {
        if (!this.theBinaryKey.get().equals(key)) {
            try {
                throw new RuntimeException("Must have same key for Redis Pipeline in Dynomite. This key: " + key);
            }
            catch (Throwable throwable) {
                this.discardPipelineAndReleaseConnection();
                throw throwable;
            }
        }
    }

    private void verifyKey(String key) {
        if (!this.theKey.get().equals(key)) {
            try {
                throw new RuntimeException("Must have same key for Redis Pipeline in Dynomite. This key: " + key);
            }
            catch (Throwable throwable) {
                this.discardPipelineAndReleaseConnection();
                throw throwable;
            }
        }
    }

    private void verifyHashtagValue(String hashtagValue) {
        if (!this.hashtag.get().equals(hashtagValue)) {
            try {
                throw new RuntimeException("Must have same hashtag for Redis Pipeline in Dynomite. This hashvalue: " + hashtagValue);
            }
            catch (Throwable throwable) {
                this.discardPipelineAndReleaseConnection();
                throw throwable;
            }
        }
    }

    private String decompressValue(String value) {
        try {
            if (ZipUtils.isCompressed((String)value)) {
                return ZipUtils.decompressFromBase64String((String)value);
            }
        }
        catch (IOException e) {
            Logger.warn("Unable to decompress value [" + value + "]");
        }
        return value;
    }

    private byte[] decompressValue(byte[] value) {
        try {
            if (ZipUtils.isCompressed((byte[])value)) {
                return ZipUtils.decompressBytesNonBase64((byte[])value);
            }
        }
        catch (IOException e) {
            Logger.warn("Unable to decompress byte array value [" + value + "]");
        }
        return value;
    }

    public Response<Long> append(final String key, final String value) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.append(key, value);
            }
        }.execute(key, OpName.APPEND);
    }

    public Response<List<String>> blpop(final String arg) {
        return new PipelineOperation<List<String>>(){

            @Override
            Response<List<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.blpop(arg);
            }
        }.execute(arg, OpName.BLPOP);
    }

    public Response<List<String>> brpop(final String arg) {
        return new PipelineOperation<List<String>>(){

            @Override
            Response<List<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.brpop(arg);
            }
        }.execute(arg, OpName.BRPOP);
    }

    public Response<Long> decr(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.decr(key);
            }
        }.execute(key, OpName.DECR);
    }

    public Response<Long> decrBy(final String key, final long integer) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.decrBy(key, integer);
            }
        }.execute(key, OpName.DECRBY);
    }

    public Response<Long> del(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.del(key);
            }
        }.execute(key, OpName.DEL);
    }

    public Response<String> echo(final String string) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.echo(string);
            }
        }.execute(string, OpName.ECHO);
    }

    public Response<Boolean> exists(final String key) {
        return new PipelineOperation<Boolean>(){

            @Override
            Response<Boolean> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.exists(key);
            }
        }.execute(key, OpName.EXISTS);
    }

    public Response<Long> expire(final String key, final int seconds) {
        return new PipelineOperation<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                long startTime = System.nanoTime() / 1000L;
                try {
                    Response response = jedisPipeline.expire(key, seconds);
                    return response;
                }
                finally {
                    long duration = System.nanoTime() / 1000L - startTime;
                    DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.EXPIRE.name(), duration, TimeUnit.MICROSECONDS);
                }
            }
        }.execute(key, OpName.EXPIRE);
    }

    public Response<Long> pexpire(String key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> expireAt(final String key, final long unixTime) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.expireAt(key, unixTime);
            }
        }.execute(key, OpName.EXPIREAT);
    }

    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<String> get(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                    long startTime = System.nanoTime() / 1000L;
                    try {
                        Response response = jedisPipeline.get(key);
                        return response;
                    }
                    finally {
                        long duration = System.nanoTime() / 1000L - startTime;
                        DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.GET.name(), duration, TimeUnit.MICROSECONDS);
                    }
                }
            }.execute(key, OpName.GET);
        }
        return new PipelineCompressionOperation<String>(){

            @Override
            Response<String> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineResponse(null).apply((Func0<? extends Response<String>>)new Func0<Response<String>>(){

                    @Override
                    public Response<String> call() {
                        return jedisPipeline.get(key);
                    }
                });
            }
        }.execute(key, OpName.GET);
    }

    public Response<Boolean> getbit(final String key, final long offset) {
        return new PipelineOperation<Boolean>(){

            @Override
            Response<Boolean> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.getbit(key, offset);
            }
        }.execute(key, OpName.GETBIT);
    }

    public Response<String> getrange(final String key, final long startOffset, final long endOffset) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.getrange(key, startOffset, endOffset);
            }
        }.execute(key, OpName.GETRANGE);
    }

    public Response<String> getSet(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<String>(){

                @Override
                Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.getSet(key, value);
                }
            }.execute(key, OpName.GETSET);
        }
        return new PipelineCompressionOperation<String>(){

            @Override
            Response<String> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineResponse(null).apply((Func0<? extends Response<String>>)new Func0<Response<String>>(){

                    @Override
                    public Response<String> call() {
                        return jedisPipeline.getSet(key, this.compressValue(value));
                    }
                });
            }
        }.execute(key, OpName.GETSET);
    }

    public Response<Long> hdel(final String key, final String ... field) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.hdel(key, field);
            }
        }.execute(key, OpName.HDEL);
    }

    public Response<Boolean> hexists(final String key, final String field) {
        return new PipelineOperation<Boolean>(){

            @Override
            Response<Boolean> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.hexists(key, field);
            }
        }.execute(key, OpName.HEXISTS);
    }

    public Response<String> hget(final String key, final String field) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<String>(){

                @Override
                Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.hget(key, field);
                }
            }.execute(key, OpName.HGET);
        }
        return new PipelineCompressionOperation<String>(){

            @Override
            Response<String> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineResponse(null).apply((Func0<? extends Response<String>>)new Func0<Response<String>>(){

                    @Override
                    public Response<String> call() {
                        return jedisPipeline.hget(key, field);
                    }
                });
            }
        }.execute(key, OpName.HGET);
    }

    public Response<byte[]> hget(final byte[] key, final byte[] field) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<byte[]>(){

                @Override
                Response<byte[]> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.hget(key, field);
                }
            }.execute(key, OpName.HGET);
        }
        return new PipelineCompressionOperation<byte[]>(){

            @Override
            Response<byte[]> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineBinaryResponse(null).apply((Func0<? extends Response<byte[]>>)new Func0<Response<byte[]>>(){

                    @Override
                    public Response<byte[]> call() {
                        return jedisPipeline.hget(key, field);
                    }
                });
            }
        }.execute(key, OpName.HGET);
    }

    public Response<Map<String, String>> hgetAll(final String key) {
        return new PipelineOperation<Map<String, String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Response<Map<String, String>> execute(Pipeline jedisPipeline) throws DynoException {
                long startTime = System.nanoTime() / 1000L;
                try {
                    Response response = jedisPipeline.hgetAll(key);
                    return response;
                }
                finally {
                    long duration = System.nanoTime() / 1000L - startTime;
                    DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.HGETALL.name(), duration, TimeUnit.MICROSECONDS);
                }
            }
        }.execute(key, OpName.HGETALL);
    }

    public Response<Map<byte[], byte[]>> hgetAll(final byte[] key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<Map<byte[], byte[]>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                Response<Map<byte[], byte[]>> execute(Pipeline jedisPipeline) throws DynoException {
                    long startTime = System.nanoTime() / 1000L;
                    try {
                        Response response = jedisPipeline.hgetAll(key);
                        return response;
                    }
                    finally {
                        long duration = System.nanoTime() / 1000L - startTime;
                        DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.HGETALL.name(), duration, TimeUnit.MICROSECONDS);
                    }
                }
            }.execute(key, OpName.HGETALL);
        }
        return new PipelineCompressionOperation<Map<byte[], byte[]>>(){

            @Override
            Response<Map<byte[], byte[]>> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineBinaryMapResponse(null).apply((Func0<? extends Response<Map<byte[], byte[]>>>)new Func0<Response<Map<byte[], byte[]>>>(){

                    @Override
                    public Response<Map<byte[], byte[]>> call() {
                        return jedisPipeline.hgetAll(key);
                    }
                });
            }
        }.execute(key, OpName.HGETALL);
    }

    public Response<Long> hincrBy(final String key, final String field, final long value) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.hincrBy(key, field, value);
            }
        }.execute(key, OpName.HINCRBY);
    }

    public Response<Double> hincrByFloat(final String key, final String field, final double value) {
        return new PipelineOperation<Double>(){

            @Override
            Response<Double> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.hincrByFloat(key, field, value);
            }
        }.execute(key, OpName.HINCRBYFLOAT);
    }

    public Response<Set<String>> hkeys(final String key) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.hkeys(key);
            }
        }.execute(key, OpName.HKEYS);
    }

    public Response<ScanResult<Map.Entry<String, String>>> hscan(String key, int cursor) {
        throw new UnsupportedOperationException("'HSCAN' cannot be called in pipeline");
    }

    public Response<Long> hlen(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.hlen(key);
            }
        }.execute(key, OpName.HLEN);
    }

    public Response<List<byte[]>> hmget(final byte[] key, final byte[] ... fields) {
        return new PipelineOperation<List<byte[]>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Response<List<byte[]>> execute(Pipeline jedisPipeline) throws DynoException {
                long startTime = System.nanoTime() / 1000L;
                try {
                    Response response = jedisPipeline.hmget(key, fields);
                    return response;
                }
                finally {
                    long duration = System.nanoTime() / 1000L - startTime;
                    DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.HMGET.name(), duration, TimeUnit.MICROSECONDS);
                }
            }
        }.execute(key, OpName.HMGET);
    }

    public Response<List<String>> hmget(final String key, final String ... fields) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<List<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                Response<List<String>> execute(Pipeline jedisPipeline) throws DynoException {
                    long startTime = System.nanoTime() / 1000L;
                    try {
                        Response response = jedisPipeline.hmget(key, fields);
                        return response;
                    }
                    finally {
                        long duration = System.nanoTime() / 1000L - startTime;
                        DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.HMGET.name(), duration, TimeUnit.MICROSECONDS);
                    }
                }
            }.execute(key, OpName.HMGET);
        }
        return new PipelineCompressionOperation<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Response<List<String>> execute(final Pipeline jedisPipeline) throws DynoException {
                long startTime = System.nanoTime() / 1000L;
                try {
                    PipelineListResponse pipelineListResponse = new PipelineListResponse(null).apply((Func0<? extends Response<List<String>>>)new Func0<Response<List<String>>>(){

                        @Override
                        public Response<List<String>> call() {
                            return jedisPipeline.hmget(key, fields);
                        }
                    });
                    return pipelineListResponse;
                }
                finally {
                    long duration = System.nanoTime() / 1000L - startTime;
                    DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.HMGET.name(), duration, TimeUnit.MICROSECONDS);
                }
            }
        }.execute(key, OpName.HGET);
    }

    public Response<String> hmset(final byte[] key, final Map<byte[], byte[]> hash) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                    long startTime = System.nanoTime() / 1000L;
                    try {
                        Response response = jedisPipeline.hmset(key, hash);
                        return response;
                    }
                    finally {
                        long duration = System.nanoTime() / 1000L - startTime;
                        DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.HMSET.name(), duration, TimeUnit.MICROSECONDS);
                    }
                }
            }.execute(key, OpName.HMSET);
        }
        return new PipelineCompressionOperation<String>(){

            @Override
            Response<String> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineResponse(null).apply((Func0<? extends Response<String>>)new Func0<Response<String>>(){

                    @Override
                    public Response<String> call() {
                        return jedisPipeline.hmset(key, CollectionUtils.transform((Map)hash, (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<byte[], byte[], byte[]>(){

                            public byte[] get(byte[] key, byte[] val) {
                                return this.compressValue(val);
                            }
                        }));
                    }
                });
            }
        }.execute(key, OpName.HMSET);
    }

    public Response<String> hmset(final String key, final Map<String, String> hash) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                    long startTime = System.nanoTime() / 1000L;
                    try {
                        Response response = jedisPipeline.hmset(key, hash);
                        return response;
                    }
                    finally {
                        long duration = System.nanoTime() / 1000L - startTime;
                        DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.HMSET.name(), duration, TimeUnit.MICROSECONDS);
                    }
                }
            }.execute(key, OpName.HMSET);
        }
        return new PipelineCompressionOperation<String>(){

            @Override
            Response<String> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineResponse(null).apply((Func0<? extends Response<String>>)new Func0<Response<String>>(){

                    @Override
                    public Response<String> call() {
                        return jedisPipeline.hmset(key, CollectionUtils.transform((Map)hash, (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<String, String, String>(){

                            public String get(String key, String val) {
                                return this.compressValue(val);
                            }
                        }));
                    }
                });
            }
        }.execute(key, OpName.HMSET);
    }

    public Response<Long> hset(final String key, final String field, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<Long>(){

                @Override
                Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.hset(key, field, value);
                }
            }.execute(key, OpName.HSET);
        }
        return new PipelineCompressionOperation<Long>(){

            @Override
            Response<Long> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineLongResponse(null).apply((Func0<? extends Response<Long>>)new Func0<Response<Long>>(){

                    @Override
                    public Response<Long> call() {
                        return jedisPipeline.hset(key, field, this.compressValue(value));
                    }
                });
            }
        }.execute(key, OpName.HSET);
    }

    public Response<Long> hset(final byte[] key, final byte[] field, final byte[] value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<Long>(){

                @Override
                Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.hset(key, field, value);
                }
            }.execute(key, OpName.HSET);
        }
        return new PipelineCompressionOperation<Long>(){

            @Override
            Response<Long> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineLongResponse(null).apply((Func0<? extends Response<Long>>)new Func0<Response<Long>>(){

                    @Override
                    public Response<Long> call() {
                        return jedisPipeline.hset(key, field, this.compressValue(value));
                    }
                });
            }
        }.execute(key, OpName.HSET);
    }

    public Response<Long> hsetnx(final String key, final String field, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<Long>(){

                @Override
                Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.hsetnx(key, field, value);
                }
            }.execute(key, OpName.HSETNX);
        }
        return new PipelineCompressionOperation<Long>(){

            @Override
            Response<Long> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineLongResponse(null).apply((Func0<? extends Response<Long>>)new Func0<Response<Long>>(){

                    @Override
                    public Response<Long> call() {
                        return jedisPipeline.hsetnx(key, field, this.compressValue(value));
                    }
                });
            }
        }.execute(key, OpName.HSETNX);
    }

    public Response<List<String>> hvals(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<List<String>>(){

                @Override
                Response<List<String>> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.hvals(key);
                }
            }.execute(key, OpName.HVALS);
        }
        return new PipelineCompressionOperation<List<String>>(){

            @Override
            Response<List<String>> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineListResponse(null).apply((Func0<? extends Response<List<String>>>)new Func0<Response<List<String>>>(){

                    @Override
                    public Response<List<String>> call() {
                        return jedisPipeline.hvals(key);
                    }
                });
            }
        }.execute(key, OpName.HVALS);
    }

    public Response<Long> incr(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.incr(key);
            }
        }.execute(key, OpName.INCR);
    }

    public Response<Long> incrBy(final String key, final long integer) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.incrBy(key, integer);
            }
        }.execute(key, OpName.INCRBY);
    }

    public Response<Double> incrByFloat(final String key, final double increment) {
        return new PipelineOperation<Double>(){

            @Override
            Response<Double> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.incrByFloat(key, increment);
            }
        }.execute(key, OpName.INCRBYFLOAT);
    }

    public Response<String> lindex(final String key, final long index) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.lindex(key, index);
            }
        }.execute(key, OpName.LINDEX);
    }

    public Response<Long> linsert(final String key, final BinaryClient.LIST_POSITION where, final String pivot, final String value) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.linsert(key, where, pivot, value);
            }
        }.execute(key, OpName.LINSERT);
    }

    public Response<Long> llen(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.llen(key);
            }
        }.execute(key, OpName.LLEN);
    }

    public Response<String> lpop(final String key) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.lpop(key);
            }
        }.execute(key, OpName.LPOP);
    }

    public Response<Long> lpush(final String key, final String ... string) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.lpush(key, string);
            }
        }.execute(key, OpName.LPUSH);
    }

    public Response<Long> lpushx(final String key, final String ... string) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.lpushx(key, string);
            }
        }.execute(key, OpName.LPUSHX);
    }

    public Response<List<String>> lrange(final String key, final long start, final long end) {
        return new PipelineOperation<List<String>>(){

            @Override
            Response<List<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.lrange(key, start, end);
            }
        }.execute(key, OpName.LRANGE);
    }

    public Response<Long> lrem(final String key, final long count, final String value) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.lrem(key, count, value);
            }
        }.execute(key, OpName.LREM);
    }

    public Response<String> lset(final String key, final long index, final String value) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.lset(key, index, value);
            }
        }.execute(key, OpName.LSET);
    }

    public Response<String> ltrim(final String key, final long start, final long end) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.ltrim(key, start, end);
            }
        }.execute(key, OpName.LTRIM);
    }

    public Response<Long> move(final String key, final int dbIndex) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.move(key, dbIndex);
            }
        }.execute(key, OpName.MOVE);
    }

    public Response<Long> persist(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.persist(key);
            }
        }.execute(key, OpName.PERSIST);
    }

    public Response<String> rename(final String oldkey, final String newkey) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.rename(oldkey, newkey);
            }
        }.execute(oldkey, OpName.RENAME);
    }

    public Response<Long> renamenx(final String oldkey, final String newkey) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.renamenx(oldkey, newkey);
            }
        }.execute(oldkey, OpName.RENAMENX);
    }

    public Response<String> rpop(final String key) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.rpop(key);
            }
        }.execute(key, OpName.RPOP);
    }

    public Response<Long> rpush(final String key, final String ... string) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.rpush(key, string);
            }
        }.execute(key, OpName.RPUSH);
    }

    public Response<Long> rpushx(final String key, final String ... string) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.rpushx(key, string);
            }
        }.execute(key, OpName.RPUSHX);
    }

    public Response<Long> sadd(final String key, final String ... member) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.sadd(key, member);
            }
        }.execute(key, OpName.SADD);
    }

    public Response<Long> scard(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.scard(key);
            }
        }.execute(key, OpName.SCARD);
    }

    public Response<Boolean> sismember(final String key, final String member) {
        return new PipelineOperation<Boolean>(){

            @Override
            Response<Boolean> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.sismember(key, member);
            }
        }.execute(key, OpName.SISMEMBER);
    }

    public Response<String> set(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                    long startTime = System.nanoTime() / 1000L;
                    try {
                        Response response = jedisPipeline.set(key, value);
                        return response;
                    }
                    finally {
                        long duration = System.nanoTime() / 1000L - startTime;
                        DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.SET.name(), duration, TimeUnit.MICROSECONDS);
                    }
                }
            }.execute(key, OpName.SET);
        }
        return new PipelineCompressionOperation<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Response<String> execute(final Pipeline jedisPipeline) throws DynoException {
                long startTime = System.nanoTime() / 1000L;
                try {
                    PipelineResponse pipelineResponse = new PipelineResponse(null).apply((Func0<? extends Response<String>>)new Func0<Response<String>>(){

                        @Override
                        public Response<String> call() {
                            return jedisPipeline.set(key, this.compressValue(value));
                        }
                    });
                    return pipelineResponse;
                }
                finally {
                    long duration = System.nanoTime() / 1000L - startTime;
                    DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.SET.name(), duration, TimeUnit.MICROSECONDS);
                }
            }
        }.execute(key, OpName.SET);
    }

    public Response<Boolean> setbit(final String key, final long offset, final boolean value) {
        return new PipelineOperation<Boolean>(){

            @Override
            Response<Boolean> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.setbit(key, offset, value);
            }
        }.execute(key, OpName.SETBIT);
    }

    public Response<String> setex(final String key, final int seconds, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return new PipelineOperation<String>(){

                @Override
                Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                    return jedisPipeline.setex(key, seconds, value);
                }
            }.execute(key, OpName.SETEX);
        }
        return new PipelineCompressionOperation<String>(){

            @Override
            Response<String> execute(final Pipeline jedisPipeline) throws DynoException {
                return new PipelineResponse(null).apply((Func0<? extends Response<String>>)new Func0<Response<String>>(){

                    @Override
                    public Response<String> call() {
                        return jedisPipeline.setex(key, seconds, this.compressValue(value));
                    }
                });
            }
        }.execute(key, OpName.SETEX);
    }

    public Response<Long> setnx(final String key, final String value) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.setnx(key, value);
            }
        }.execute(key, OpName.SETNX);
    }

    public Response<Long> setrange(final String key, final long offset, final String value) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.setrange(key, offset, value);
            }
        }.execute(key, OpName.SETRANGE);
    }

    public Response<Set<String>> smembers(final String key) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.smembers(key);
            }
        }.execute(key, OpName.SMEMBERS);
    }

    public Response<List<String>> sort(final String key) {
        return new PipelineOperation<List<String>>(){

            @Override
            Response<List<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.sort(key);
            }
        }.execute(key, OpName.SORT);
    }

    public Response<List<String>> sort(final String key, final SortingParams sortingParameters) {
        return new PipelineOperation<List<String>>(){

            @Override
            Response<List<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.sort(key, sortingParameters);
            }
        }.execute(key, OpName.SORT);
    }

    public Response<String> spop(final String key) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.spop(key);
            }
        }.execute(key, OpName.SPOP);
    }

    public Response<Set<String>> spop(String key, long count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<String> srandmember(final String key) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.srandmember(key);
            }
        }.execute(key, OpName.SRANDMEMBER);
    }

    public Response<Long> srem(final String key, final String ... member) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.srem(key, member);
            }
        }.execute(key, OpName.SREM);
    }

    public Response<ScanResult<String>> sscan(String key, int cursor) {
        throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline");
    }

    public Response<ScanResult<String>> sscan(String key, String cursor) {
        throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline");
    }

    public Response<Long> strlen(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.strlen(key);
            }
        }.execute(key, OpName.STRLEN);
    }

    public Response<String> substr(final String key, final int start, final int end) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.substr(key, start, end);
            }
        }.execute(key, OpName.SUBSTR);
    }

    public Response<Long> ttl(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.ttl(key);
            }
        }.execute(key, OpName.TTL);
    }

    public Response<String> type(final String key) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.type(key);
            }
        }.execute(key, OpName.TYPE);
    }

    public Response<Long> zadd(final String key, final double score, final String member) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zadd(key, score, member);
            }
        }.execute(key, OpName.ZADD);
    }

    public Response<Long> zadd(final String key, final Map<String, Double> scoreMembers) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zadd(key, scoreMembers);
            }
        }.execute(key, OpName.ZADD);
    }

    public Response<Long> zcard(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zcard(key);
            }
        }.execute(key, OpName.ZCARD);
    }

    public Response<Long> zcount(final String key, final double min, final double max) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zcount(key, min, max);
            }
        }.execute(key, OpName.ZCOUNT);
    }

    public Response<Double> zincrby(final String key, final double score, final String member) {
        return new PipelineOperation<Double>(){

            @Override
            Response<Double> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zincrby(key, score, member);
            }
        }.execute(key, OpName.ZINCRBY);
    }

    public Response<Set<String>> zrange(final String key, final long start, final long end) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrange(key, start, end);
            }
        }.execute(key, OpName.ZRANGE);
    }

    public Response<Set<String>> zrangeByScore(final String key, final double min, final double max) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrangeByScore(key, min, max);
            }
        }.execute(key, OpName.ZRANGEBYSCORE);
    }

    public Response<Set<String>> zrangeByScore(final String key, final String min, final String max) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrangeByScore(key, min, max);
            }
        }.execute(key, OpName.ZRANGEBYSCORE);
    }

    public Response<Set<String>> zrangeByScore(final String key, final double min, final double max, final int offset, final int count) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrangeByScore(key, min, max, offset, count);
            }
        }.execute(key, OpName.ZRANGEBYSCORE);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(final String key, final double min, final double max) {
        return new PipelineOperation<Set<Tuple>>(){

            @Override
            Response<Set<Tuple>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrangeByScoreWithScores(key, min, max);
            }
        }.execute(key, OpName.ZRANGEBYSCOREWITHSCORES);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(final String key, final double min, final double max, final int offset, final int count) {
        return new PipelineOperation<Set<Tuple>>(){

            @Override
            Response<Set<Tuple>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrangeByScoreWithScores(key, min, max, offset, count);
            }
        }.execute(key, OpName.ZRANGEBYSCOREWITHSCORES);
    }

    public Response<Set<String>> zrevrangeByScore(final String key, final double max, final double min) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrangeByScore(key, max, min);
            }
        }.execute(key, OpName.ZREVRANGEBYSCORE);
    }

    public Response<Set<String>> zrevrangeByScore(final String key, final String max, final String min) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrangeByScore(key, max, min);
            }
        }.execute(key, OpName.ZREVRANGEBYSCORE);
    }

    public Response<Set<String>> zrevrangeByScore(final String key, final double max, final double min, final int offset, final int count) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrangeByScore(key, max, min, offset, count);
            }
        }.execute(key, OpName.ZREVRANGEBYSCORE);
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final String key, final double max, final double min) {
        return new PipelineOperation<Set<Tuple>>(){

            @Override
            Response<Set<Tuple>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrangeByScoreWithScores(key, max, min);
            }
        }.execute(key, OpName.ZREVRANGEBYSCOREWITHSCORES);
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final String key, final double max, final double min, final int offset, final int count) {
        return new PipelineOperation<Set<Tuple>>(){

            @Override
            Response<Set<Tuple>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrangeByScoreWithScores(key, max, min, offset, count);
            }
        }.execute(key, OpName.ZREVRANGEBYSCOREWITHSCORES);
    }

    public Response<Set<Tuple>> zrangeWithScores(final String key, final long start, final long end) {
        return new PipelineOperation<Set<Tuple>>(){

            @Override
            Response<Set<Tuple>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrangeWithScores(key, start, end);
            }
        }.execute(key, OpName.ZRANGEWITHSCORES);
    }

    public Response<Long> zrank(final String key, final String member) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrank(key, member);
            }
        }.execute(key, OpName.ZRANK);
    }

    public Response<Long> zrem(final String key, final String ... member) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrem(key, member);
            }
        }.execute(key, OpName.ZREM);
    }

    public Response<Long> zremrangeByRank(final String key, final long start, final long end) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zremrangeByRank(key, start, end);
            }
        }.execute(key, OpName.ZREMRANGEBYRANK);
    }

    public Response<Long> zremrangeByScore(final String key, final double start, final double end) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zremrangeByScore(key, start, end);
            }
        }.execute(key, OpName.ZREMRANGEBYSCORE);
    }

    public Response<Set<String>> zrevrange(final String key, final long start, final long end) {
        return new PipelineOperation<Set<String>>(){

            @Override
            Response<Set<String>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrange(key, start, end);
            }
        }.execute(key, OpName.ZREVRANGE);
    }

    public Response<Set<Tuple>> zrevrangeWithScores(final String key, final long start, final long end) {
        return new PipelineOperation<Set<Tuple>>(){

            @Override
            Response<Set<Tuple>> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrangeWithScores(key, start, end);
            }
        }.execute(key, OpName.ZREVRANGEWITHSCORES);
    }

    public Response<Long> zrevrank(final String key, final String member) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zrevrank(key, member);
            }
        }.execute(key, OpName.ZREVRANK);
    }

    public Response<Double> zscore(final String key, final String member) {
        return new PipelineOperation<Double>(){

            @Override
            Response<Double> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zscore(key, member);
            }
        }.execute(key, OpName.ZSCORE);
    }

    public Response<ScanResult<Tuple>> zscan(String key, int cursor) {
        throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline");
    }

    public Response<Long> zlexcount(String key, String min, String max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<String>> zrangeByLex(String key, String min, String max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zremrangeByLex(String key, String start, String end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> bitcount(final String key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.bitcount(key);
            }
        }.execute(key, OpName.BITCOUNT);
    }

    public Response<Long> bitcount(final String key, final long start, final long end) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.bitcount(key, start, end);
            }
        }.execute(key, OpName.BITCOUNT);
    }

    public Response<String> set(final byte[] key, final byte[] value) {
        return new PipelineOperation<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                long startTime = System.nanoTime() / 1000L;
                try {
                    Response response = jedisPipeline.set(key, value);
                    return response;
                }
                finally {
                    long duration = System.nanoTime() / 1000L - startTime;
                    DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.SET.name(), duration, TimeUnit.MICROSECONDS);
                }
            }
        }.execute(key, OpName.SET);
    }

    public Response<Long> pfadd(String key, String ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> pfcount(String key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<Long>> bitfield(String key, String ... arguments) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<String>> zrevrangeByLex(String key, String max, String min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<String>> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> geoadd(String arg0, Map<String, GeoCoordinate> arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> geoadd(String arg0, double arg1, double arg2, String arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Double> geodist(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Double> geodist(String arg0, String arg1, String arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<String>> geohash(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoCoordinate>> geopos(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zadd(String arg0, Map<String, Double> arg1, ZAddParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zadd(final String key, final double score, final String member, final ZAddParams params) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.zadd(key, score, member, params);
            }
        }.execute(key, OpName.ZADD);
    }

    public Response<Double> zincrby(String arg0, double arg1, String arg2, ZIncrByParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void sync() {
        long startTime = System.nanoTime() / 1000L;
        try {
            this.jedisPipeline.sync();
            this.opMonitor.recordPipelineSync();
        }
        catch (JedisConnectionException jce) {
            String msg = "Failed sync() to host: " + this.getHostInfo();
            this.pipelineEx.set((DynoException)new FatalConnectionException(msg, (Throwable)jce).setHost(this.connection == null ? Host.NO_HOST : this.connection.getHost()));
            this.cpMonitor.incOperationFailure(this.connection == null ? null : this.connection.getHost(), (Exception)((Object)jce));
            throw jce;
        }
        finally {
            long duration = System.nanoTime() / 1000L - startTime;
            this.opMonitor.recordLatency(duration, TimeUnit.MICROSECONDS);
            this.discardPipeline(false);
            this.releaseConnection();
        }
    }

    public List<Object> syncAndReturnAll() {
        long startTime = System.nanoTime() / 1000L;
        try {
            List result = this.jedisPipeline.syncAndReturnAll();
            this.opMonitor.recordPipelineSync();
            List list = result;
            return list;
        }
        catch (JedisConnectionException jce) {
            String msg = "Failed syncAndReturnAll() to host: " + this.getHostInfo();
            this.pipelineEx.set((DynoException)new FatalConnectionException(msg, (Throwable)jce).setHost(this.connection == null ? Host.NO_HOST : this.connection.getHost()));
            this.cpMonitor.incOperationFailure(this.connection == null ? null : this.connection.getHost(), (Exception)((Object)jce));
            throw jce;
        }
        finally {
            long duration = System.nanoTime() / 1000L - startTime;
            this.opMonitor.recordLatency(duration, TimeUnit.MICROSECONDS);
            this.discardPipeline(false);
            this.releaseConnection();
        }
    }

    private void discardPipeline(boolean recordLatency) {
        try {
            if (this.jedisPipeline != null) {
                long startTime = System.nanoTime() / 1000L;
                this.jedisPipeline.sync();
                if (recordLatency) {
                    long duration = System.nanoTime() / 1000L - startTime;
                    this.opMonitor.recordLatency(duration, TimeUnit.MICROSECONDS);
                }
                this.jedisPipeline = null;
            }
        }
        catch (Exception e) {
            Logger.warn(String.format("Failed to discard jedis pipeline, %s", this.getHostInfo()), (Throwable)e);
        }
    }

    private void releaseConnection() {
        if (this.connection != null) {
            try {
                this.connection.getContext().reset();
                this.connection.getParentConnectionPool().returnConnection(this.connection);
                if (this.pipelineEx.get() != null) {
                    this.connPool.getHealthTracker().trackConnectionError(this.connection.getParentConnectionPool(), this.pipelineEx.get());
                    this.pipelineEx.set(null);
                }
                this.connection = null;
            }
            catch (Exception e) {
                Logger.warn(String.format("Failed to return connection in Dyno Jedis Pipeline, %s", this.getHostInfo()), (Throwable)e);
            }
        }
    }

    public void discardPipelineAndReleaseConnection() {
        this.opMonitor.recordPipelineDiscard();
        this.discardPipeline(true);
        this.releaseConnection();
    }

    @Override
    public void close() throws Exception {
        this.discardPipelineAndReleaseConnection();
    }

    private String getHostInfo() {
        if (this.connection != null && this.connection.getHost() != null) {
            return this.connection.getHost().toString();
        }
        return "unknown";
    }

    public Response<Long> append(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<byte[]>> blpop(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<byte[]>> brpop(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> decr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> decrBy(final byte[] key, final long integer) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.decrBy(key, integer);
            }
        }.execute(key, OpName.DECRBY);
    }

    public Response<Long> del(final byte[] key) {
        return new PipelineOperation<Long>(){

            @Override
            Response<Long> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.del(key);
            }
        }.execute(key, OpName.DEL);
    }

    public Response<byte[]> echo(byte[] string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Boolean> exists(final byte[] key) {
        return new PipelineOperation<Boolean>(){

            @Override
            Response<Boolean> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.exists(key);
            }
        }.execute(key, OpName.EXISTS);
    }

    public Response<Long> expire(byte[] key, int seconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> pexpire(byte[] key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> expireAt(byte[] key, long unixTime) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<byte[]> get(final byte[] key) {
        return new PipelineOperation<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Response<byte[]> execute(Pipeline jedisPipeline) throws DynoException {
                long startTime = System.nanoTime() / 1000L;
                try {
                    Response response = jedisPipeline.get(key);
                    return response;
                }
                finally {
                    long duration = System.nanoTime() / 1000L - startTime;
                    DynoJedisPipeline.this.opMonitor.recordSendLatency(OpName.GET.name(), duration, TimeUnit.MICROSECONDS);
                }
            }
        }.execute(key, OpName.GET);
    }

    public Response<Boolean> getbit(byte[] key, long offset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<byte[]> getSet(final byte[] key, final byte[] value) {
        return new PipelineOperation<byte[]>(){

            @Override
            Response<byte[]> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.getSet(key, value);
            }
        }.execute(key, OpName.GETSET);
    }

    public Response<Long> getrange(byte[] key, long startOffset, long endOffset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> hdel(byte[] key, byte[] ... field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Boolean> hexists(byte[] key, byte[] field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> hkeys(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> hlen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<byte[]>> hvals(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> incr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> incrBy(byte[] key, long integer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<byte[]> lindex(byte[] key, long index) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> llen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<byte[]> lpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> lpush(byte[] key, byte[] ... string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> lpushx(byte[] key, byte[] ... bytes) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<String> lset(byte[] key, long index, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<String> ltrim(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> persist(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<byte[]> rpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> rpush(byte[] key, byte[] ... string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> rpushx(byte[] key, byte[] ... string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> sadd(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> scard(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Boolean> setbit(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> setrange(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<String> setex(final byte[] key, final int seconds, final byte[] value) {
        return new PipelineOperation<String>(){

            @Override
            Response<String> execute(Pipeline jedisPipeline) throws DynoException {
                return jedisPipeline.setex(key, seconds, value);
            }
        }.execute(key, OpName.SETEX);
    }

    public Response<Long> setnx(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> smembers(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Boolean> sismember(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<byte[]>> sort(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<byte[]> spop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> spop(byte[] key, long count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<byte[]> srandmember(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> srem(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> strlen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<String> substr(byte[] key, int start, int end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> ttl(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<String> type(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zcard(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zcount(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Double> zincrby(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Double> zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zrem(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zremrangeByRank(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zremrangeByScore(byte[] key, double start, double end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrevrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zrevrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Double> zscore(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zlexcount(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> bitcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> bitcount(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> pfadd(byte[] key, byte[] ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> pfcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Long> geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<byte[]>> geohash(byte[] key, byte[] ... members) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoCoordinate>> geopos(byte[] key, byte[] ... members) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Response<List<Long>> bitfield(byte[] key, byte[] ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private abstract class PipelineCompressionOperation<R>
    extends PipelineOperation<R> {
        private PipelineCompressionOperation() {
        }

        public String compressValue(String value) {
            String result = value;
            int thresholdBytes = DynoJedisPipeline.this.connPool.getConfiguration().getValueCompressionThreshold();
            try {
                if (2 * value.length() > thresholdBytes) {
                    result = ZipUtils.compressStringToBase64String((String)value);
                }
            }
            catch (IOException e) {
                Logger.warn("UNABLE to compress [" + value + "]; sending value uncompressed");
            }
            return result;
        }

        public byte[] compressValue(byte[] value) {
            int thresholdBytes = DynoJedisPipeline.this.connPool.getConfiguration().getValueCompressionThreshold();
            if (value.length > thresholdBytes) {
                try {
                    return ZipUtils.compressBytesNonBase64((byte[])value);
                }
                catch (IOException e) {
                    Logger.warn("UNABLE to compress byte array [" + value + "]; sending value uncompressed");
                }
            }
            return value;
        }
    }

    private abstract class PipelineOperation<R> {
        private PipelineOperation() {
        }

        abstract Response<R> execute(Pipeline var1) throws DynoException;

        Response<R> execute(byte[] key, OpName opName) {
            DynoJedisPipeline.this.checkKey(key);
            return this.execute(key, opName);
        }

        Response<R> execute(String key, OpName opName) {
            DynoJedisPipeline.this.checkKey(key);
            return this.executeOperation(opName);
        }

        Response<R> executeOperation(OpName opName) {
            try {
                DynoJedisPipeline.this.opMonitor.recordOperation(opName.name());
                return this.execute(DynoJedisPipeline.this.jedisPipeline);
            }
            catch (JedisConnectionException ex) {
                this.handleConnectionException(ex);
                throw ex;
            }
        }

        void handleConnectionException(JedisConnectionException ex) {
            DynoConnectException e = new FatalConnectionException((Throwable)ex).setAttempt(1);
            DynoJedisPipeline.this.pipelineEx.set(e);
            DynoJedisPipeline.this.cpMonitor.incOperationFailure(DynoJedisPipeline.this.connection.getHost(), (Exception)e);
        }
    }

    public class PipelineBinaryMapResponse
    extends Response<Map<byte[], byte[]>> {
        private Response<Map<byte[], byte[]>> response;

        public PipelineBinaryMapResponse(Builder<Map<byte[], byte[]>> b) {
            super(BuilderFactory.BYTE_ARRAY_MAP);
        }

        public PipelineBinaryMapResponse apply(Func0<? extends Response<Map<byte[], byte[]>>> f) {
            this.response = f.call();
            return this;
        }

        public Map<byte[], byte[]> get() {
            return CollectionUtils.transform((Map)((Map)this.response.get()), (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<byte[], byte[], byte[]>(){

                public byte[] get(byte[] key, byte[] val) {
                    return DynoJedisPipeline.this.decompressValue(val);
                }
            });
        }
    }

    public class PipelineMapResponse
    extends Response<Map<String, String>> {
        private Response<Map<String, String>> response;

        public PipelineMapResponse(Builder<Map<String, String>> b) {
            super(BuilderFactory.STRING_MAP);
        }

        public Map<String, String> get() {
            return CollectionUtils.transform((Map)((Map)this.response.get()), (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<String, String, String>(){

                public String get(String key, String val) {
                    return DynoJedisPipeline.this.decompressValue(val);
                }
            });
        }
    }

    public class PipelineBinaryResponse
    extends Response<byte[]> {
        private Response<byte[]> response;

        public PipelineBinaryResponse(Builder<String> b) {
            super(BuilderFactory.BYTE_ARRAY);
        }

        public PipelineBinaryResponse apply(Func0<? extends Response<byte[]>> f) {
            this.response = f.call();
            return this;
        }

        public byte[] get() {
            return DynoJedisPipeline.this.decompressValue((byte[])this.response.get());
        }
    }

    public class PipelineListResponse
    extends Response<List<String>> {
        private Response<List<String>> response;

        public PipelineListResponse(Builder<List> b) {
            super(BuilderFactory.STRING_LIST);
        }

        public PipelineListResponse apply(Func0<? extends Response<List<String>>> f) {
            this.response = f.call();
            return this;
        }

        public List<String> get() {
            return new ArrayList<String>(CollectionUtils.transform((Collection)((Collection)this.response.get()), (CollectionUtils.Transform)new CollectionUtils.Transform<String, String>(){

                public String get(String s) {
                    return DynoJedisPipeline.this.decompressValue(s);
                }
            }));
        }
    }

    public class PipelineLongResponse
    extends Response<Long> {
        private Response<Long> response;

        public PipelineLongResponse(Builder<Long> b) {
            super(b);
        }

        public PipelineLongResponse apply(Func0<? extends Response<Long>> f) {
            this.response = f.call();
            return this;
        }
    }

    public class PipelineResponse
    extends Response<String> {
        private Response<String> response;

        public PipelineResponse(Builder<String> b) {
            super(BuilderFactory.STRING);
        }

        public PipelineResponse apply(Func0<? extends Response<String>> f) {
            this.response = f.call();
            return this;
        }

        public String get() {
            return DynoJedisPipeline.this.decompressValue((String)this.response.get());
        }
    }

    private static interface Func0<R> {
        public R call();
    }
}

