/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.dyno.connectionpool.AsyncOperation;
import com.netflix.dyno.connectionpool.Connection;
import com.netflix.dyno.connectionpool.ConnectionContext;
import com.netflix.dyno.connectionpool.ConnectionFactory;
import com.netflix.dyno.connectionpool.ConnectionObservor;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostConnectionPool;
import com.netflix.dyno.connectionpool.ListenableFuture;
import com.netflix.dyno.connectionpool.Operation;
import com.netflix.dyno.connectionpool.OperationMonitor;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.connectionpool.exception.DynoConnectException;
import com.netflix.dyno.connectionpool.exception.DynoException;
import com.netflix.dyno.connectionpool.exception.FatalConnectionException;
import com.netflix.dyno.connectionpool.exception.ThrottledException;
import com.netflix.dyno.connectionpool.impl.ConnectionContextImpl;
import com.netflix.dyno.connectionpool.impl.OperationResultImpl;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class JedisConnectionFactory
implements ConnectionFactory<Jedis> {
    private static final Logger Logger = LoggerFactory.getLogger(JedisConnectionFactory.class);
    private final OperationMonitor opMonitor;
    private final SSLSocketFactory sslSocketFactory;

    public JedisConnectionFactory(OperationMonitor monitor, SSLSocketFactory sslSocketFactory) {
        this.opMonitor = monitor;
        this.sslSocketFactory = sslSocketFactory;
    }

    public Connection<Jedis> createConnection(HostConnectionPool<Jedis> pool, ConnectionObservor connectionObservor) throws DynoConnectException, ThrottledException {
        return new JedisConnection(pool);
    }

    public class JedisConnection
    implements Connection<Jedis> {
        private final HostConnectionPool<Jedis> hostPool;
        private final Jedis jedisClient;
        private final ConnectionContextImpl context = new ConnectionContextImpl();
        private DynoConnectException lastDynoException;

        public JedisConnection(HostConnectionPool<Jedis> hostPool) {
            this.hostPool = hostPool;
            Host host = hostPool.getHost();
            this.jedisClient = JedisConnectionFactory.this.sslSocketFactory == null ? new Jedis(host.getHostAddress(), host.getPort(), hostPool.getConnectionTimeout(), hostPool.getSocketTimeout()) : new Jedis(host.getHostAddress(), host.getSecurePort(), hostPool.getConnectionTimeout(), hostPool.getSocketTimeout(), true, JedisConnectionFactory.this.sslSocketFactory, new SSLParameters(), null);
        }

        public <R> OperationResult<R> execute(Operation<Jedis, R> op) throws DynoException {
            long startTime = System.nanoTime() / 1000L;
            String opName = op.getName();
            OperationResultImpl opResult = null;
            try {
                Object result = op.execute((Object)this.jedisClient, (ConnectionContext)this.context);
                if (this.context.hasMetadata("compression") || this.context.hasMetadata("decompression")) {
                    JedisConnectionFactory.this.opMonitor.recordSuccess(opName, true);
                } else {
                    JedisConnectionFactory.this.opMonitor.recordSuccess(opName);
                }
                opResult = new OperationResultImpl(opName, result, JedisConnectionFactory.this.opMonitor);
                opResult.addMetadata("connectionId", String.valueOf(this.hashCode()));
                OperationResultImpl operationResultImpl = opResult;
                return operationResultImpl;
            }
            catch (JedisConnectionException ex) {
                Logger.warn("Caught JedisConnectionException: " + ex.getMessage());
                JedisConnectionFactory.this.opMonitor.recordFailure(opName, ex.getMessage());
                this.lastDynoException = new FatalConnectionException((Throwable)ex).setAttempt(1).setHost(this.getHost());
                throw this.lastDynoException;
            }
            catch (RuntimeException ex) {
                Logger.warn("Caught RuntimeException: " + ex.getMessage());
                JedisConnectionFactory.this.opMonitor.recordFailure(opName, ex.getMessage());
                this.lastDynoException = new FatalConnectionException((Throwable)ex).setAttempt(1).setHost(this.getHost());
                throw this.lastDynoException;
            }
            finally {
                long duration = System.nanoTime() / 1000L - startTime;
                if (opResult != null) {
                    opResult.setLatency(duration, TimeUnit.MICROSECONDS);
                }
            }
        }

        public <R> ListenableFuture<OperationResult<R>> executeAsync(AsyncOperation<Jedis, R> op) throws DynoException {
            throw new NotImplementedException();
        }

        public void close() {
            this.jedisClient.quit();
            this.jedisClient.disconnect();
        }

        public Host getHost() {
            return this.hostPool.getHost();
        }

        public void open() throws DynoException {
            this.jedisClient.connect();
        }

        public DynoConnectException getLastException() {
            return this.lastDynoException;
        }

        public HostConnectionPool<Jedis> getParentConnectionPool() {
            return this.hostPool;
        }

        public void execPing() {
            String result;
            try {
                result = this.jedisClient.ping();
            }
            catch (JedisConnectionException e) {
                throw new DynoConnectException("Unsuccessful ping", (Throwable)e);
            }
            if (result == null || result.isEmpty()) {
                throw new DynoConnectException("Unsuccessful ping, got empty result");
            }
        }

        public ConnectionContext getContext() {
            return this.context;
        }

        public Jedis getClient() {
            return this.jedisClient;
        }
    }
}

