/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.netflix.discovery.AzToRegionMapper;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.InstanceRegionChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzToRegionMapper
implements AzToRegionMapper {
    private static final Logger logger = LoggerFactory.getLogger(InstanceRegionChecker.class);
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    protected final EurekaClientConfig clientConfig;
    private final Multimap<String, String> defaultRegionVsAzMap = Multimaps.newListMultimap(new HashMap(), (Supplier)new Supplier<List<String>>(){

        public List<String> get() {
            return new ArrayList<String>();
        }
    });
    private final Map<String, String> availabilityZoneVsRegion = new ConcurrentHashMap<String, String>();
    private String[] regionsToFetch;

    protected AbstractAzToRegionMapper(EurekaClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.populateDefaultAZToRegionMap();
    }

    @Override
    public synchronized void setRegionsToFetch(String[] regionsToFetch) {
        if (null != regionsToFetch) {
            this.regionsToFetch = regionsToFetch;
            logger.info("Fetching availability zone to region mapping for regions {}", (Object)regionsToFetch);
            this.availabilityZoneVsRegion.clear();
            for (String remoteRegion : regionsToFetch) {
                Set<String> availabilityZones = this.getZonesForARegion(remoteRegion);
                if (null == availabilityZones || availabilityZones.size() == 1 && availabilityZones.contains("defaultZone") || availabilityZones.isEmpty()) {
                    logger.info("No availability zone information available for remote region: {}. Now checking in the default mapping.", (Object)remoteRegion);
                    if (this.defaultRegionVsAzMap.containsKey((Object)remoteRegion)) {
                        Collection defaultAvailabilityZones = this.defaultRegionVsAzMap.get((Object)remoteRegion);
                        for (String defaultAvailabilityZone : defaultAvailabilityZones) {
                            this.availabilityZoneVsRegion.put(defaultAvailabilityZone, remoteRegion);
                        }
                        continue;
                    }
                    String msg = "No availability zone information available for remote region: " + remoteRegion + ". This is required if registry information for this region is configured to be fetched.";
                    logger.error(msg);
                    throw new RuntimeException(msg);
                }
                for (String availabilityZone : availabilityZones) {
                    this.availabilityZoneVsRegion.put(availabilityZone, remoteRegion);
                }
            }
            logger.info("Availability zone to region mapping for all remote regions: {}", this.availabilityZoneVsRegion);
        } else {
            logger.info("Regions to fetch is null. Erasing older mapping if any.");
            this.availabilityZoneVsRegion.clear();
            this.regionsToFetch = EMPTY_STR_ARRAY;
        }
    }

    protected abstract Set<String> getZonesForARegion(String var1);

    @Override
    public String getRegionForAvailabilityZone(String availabilityZone) {
        String region = this.availabilityZoneVsRegion.get(availabilityZone);
        if (null == region) {
            return this.parseAzToGetRegion(availabilityZone);
        }
        return region;
    }

    @Override
    public synchronized void refreshMapping() {
        logger.info("Refreshing availability zone to region mappings.");
        this.setRegionsToFetch(this.regionsToFetch);
    }

    protected String parseAzToGetRegion(String availabilityZone) {
        String possibleRegion;
        if (!availabilityZone.isEmpty() && this.availabilityZoneVsRegion.containsValue(possibleRegion = availabilityZone.substring(0, availabilityZone.length() - 1))) {
            return possibleRegion;
        }
        return null;
    }

    private void populateDefaultAZToRegionMap() {
        this.defaultRegionVsAzMap.put((Object)"us-east-1", (Object)"us-east-1a");
        this.defaultRegionVsAzMap.put((Object)"us-east-1", (Object)"us-east-1c");
        this.defaultRegionVsAzMap.put((Object)"us-east-1", (Object)"us-east-1d");
        this.defaultRegionVsAzMap.put((Object)"us-east-1", (Object)"us-east-1e");
        this.defaultRegionVsAzMap.put((Object)"us-west-1", (Object)"us-west-1a");
        this.defaultRegionVsAzMap.put((Object)"us-west-1", (Object)"us-west-1c");
        this.defaultRegionVsAzMap.put((Object)"us-west-2", (Object)"us-west-2a");
        this.defaultRegionVsAzMap.put((Object)"us-west-2", (Object)"us-west-2b");
        this.defaultRegionVsAzMap.put((Object)"us-west-2", (Object)"us-west-2c");
        this.defaultRegionVsAzMap.put((Object)"eu-west-1", (Object)"eu-west-1a");
        this.defaultRegionVsAzMap.put((Object)"eu-west-1", (Object)"eu-west-1b");
        this.defaultRegionVsAzMap.put((Object)"eu-west-1", (Object)"eu-west-1c");
    }
}

