/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.dynomite.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.NamedCacheFactory;
import com.netflix.spinnaker.cats.cache.WriteableCache;
import com.netflix.spinnaker.cats.compression.CompressionStrategy;
import com.netflix.spinnaker.cats.dynomite.cache.DynomiteCache;
import com.netflix.spinnaker.cats.redis.cache.RedisCacheOptions;
import com.netflix.spinnaker.kork.dynomite.DynomiteClientDelegate;
import java.util.Optional;

public class DynomiteNamedCacheFactory
implements NamedCacheFactory {
    private final Optional<String> keyspace;
    private final DynomiteClientDelegate dynomiteClientDelegate;
    private final ObjectMapper objectMapper;
    private final RedisCacheOptions options;
    private final DynomiteCache.CacheMetrics cacheMetrics;
    private final CompressionStrategy compressionStrategy;

    public DynomiteNamedCacheFactory(Optional<String> keyspace, DynomiteClientDelegate dynomiteClientDelegate, ObjectMapper objectMapper, RedisCacheOptions options, DynomiteCache.CacheMetrics cacheMetrics, CompressionStrategy compressionStrategy) {
        this.keyspace = keyspace;
        this.dynomiteClientDelegate = dynomiteClientDelegate;
        this.objectMapper = objectMapper;
        this.options = options;
        this.cacheMetrics = cacheMetrics;
        this.compressionStrategy = compressionStrategy;
    }

    public WriteableCache getCache(String name) {
        return new DynomiteCache(this.getPrefix(name), this.dynomiteClientDelegate, this.objectMapper, this.options, this.cacheMetrics, this.compressionStrategy);
    }

    private String getPrefix(String name) {
        return this.keyspace.map(k -> name + "-" + k).orElse(name);
    }
}

