/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.redis.cluster;

import com.netflix.spinnaker.cats.redis.cluster.NodeIdentity;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultNodeIdentity
implements NodeIdentity {
    public static final String UNKNOWN_HOST = "UnknownHost";
    private static final long REFRESH_INTERVAL = TimeUnit.SECONDS.toMillis(30L);
    private final String validationAddress;
    private final int validationPort;
    private final String runtimeName;
    private final AtomicReference<String> identity = new AtomicReference<Object>(null);
    private final AtomicBoolean validIdentity = new AtomicBoolean(false);
    private final AtomicLong refreshTime = new AtomicLong(0L);
    private final Lock refreshLock = new ReentrantLock();
    private final long refreshInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHostName(String validationHost, int validationPort) {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ignored) {
            return UNKNOWN_HOST;
        }
        if (interfaces == null) {
            return UNKNOWN_HOST;
        }
        for (NetworkInterface networkInterface : Collections.list(interfaces)) {
            try {
                if (networkInterface.isLoopback()) continue;
                if (!networkInterface.isUp()) {
                }
            }
            catch (SocketException ignored) {}
            continue;
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                Socket socket = null;
                try {
                    socket = new Socket();
                    socket.bind(new InetSocketAddress(address, 0));
                    socket.connect(new InetSocketAddress(validationHost, validationPort), 125);
                    String string = address.getHostName();
                    return string;
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (socket == null) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return UNKNOWN_HOST;
    }

    public DefaultNodeIdentity() {
        this("www.google.com", 80);
    }

    public DefaultNodeIdentity(String validationAddress, int validationPort) {
        this(validationAddress, validationPort, REFRESH_INTERVAL);
    }

    public DefaultNodeIdentity(String validationAddress, int validationPort, long refreshInterval) {
        this.validationAddress = validationAddress;
        this.validationPort = validationPort;
        this.runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        this.refreshInterval = refreshInterval;
        this.loadIdentity();
    }

    @Override
    public String getNodeIdentity() {
        if (!this.validIdentity.get() && this.shouldRefresh()) {
            this.refreshLock.lock();
            try {
                if (!this.validIdentity.get() && this.shouldRefresh()) {
                    this.loadIdentity();
                }
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        return this.identity.get();
    }

    private boolean shouldRefresh() {
        return System.currentTimeMillis() - this.refreshTime.get() > this.refreshInterval;
    }

    private void loadIdentity() {
        this.identity.set(String.format("%s:%s", DefaultNodeIdentity.getHostName(this.validationAddress, this.validationPort), this.runtimeName));
        this.validIdentity.set(!this.identity.get().contains(UNKNOWN_HOST));
        this.refreshTime.set(System.currentTimeMillis());
    }
}

