/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.redis.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Iterables;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.WriteableCache;
import com.netflix.spinnaker.cats.redis.cache.RedisCacheOptions;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public abstract class AbstractRedisCache
implements WriteableCache {
    protected static final TypeReference<Map<String, Object>> ATTRIBUTES = new TypeReference<Map<String, Object>>(){};
    protected static final TypeReference<List<String>> RELATIONSHIPS = new TypeReference<List<String>>(){};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String prefix;
    protected final RedisClientDelegate redisClientDelegate;
    protected final ObjectMapper objectMapper;
    protected final RedisCacheOptions options;

    protected AbstractRedisCache(String prefix, RedisClientDelegate redisClientDelegate, ObjectMapper objectMapper, RedisCacheOptions options) {
        this.prefix = prefix;
        this.redisClientDelegate = redisClientDelegate;
        this.objectMapper = objectMapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        this.options = options;
    }

    protected abstract void mergeItems(String var1, Collection<CacheData> var2);

    protected abstract void evictItems(String var1, List<String> var2, Collection<String> var3);

    protected abstract Collection<CacheData> getItems(String var1, List<String> var2, List<String> var3);

    public void merge(String type, CacheData item) {
        this.mergeAll(type, Arrays.asList(item));
    }

    public void mergeAll(String type, Collection<CacheData> items) {
        for (List partition : Iterables.partition(items, (int)this.options.getMaxMergeBatchSize())) {
            this.mergeItems(type, partition);
        }
    }

    public void evict(String type, String id) {
        this.evictAll(type, Arrays.asList(id));
    }

    public void evictAll(String type, Collection<String> identifiers) {
        if (identifiers.isEmpty()) {
            return;
        }
        Set<String> allRelationships = this.scanMembers(this.allRelationshipsId(type));
        for (List items : Iterables.partition(new HashSet<String>(identifiers), (int)this.options.getMaxEvictBatchSize())) {
            this.evictItems(type, items, allRelationships);
        }
    }

    public CacheData get(String type, String id) {
        return this.get(type, id, null);
    }

    public CacheData get(String type, String id, CacheFilter cacheFilter) {
        Collection<CacheData> result = this.getAll(type, Arrays.asList(id), cacheFilter);
        if (result.isEmpty()) {
            return null;
        }
        return result.iterator().next();
    }

    public Collection<String> existingIdentifiers(String type, Collection<String> identifiers) {
        LinkedHashMap responses = new LinkedHashMap();
        this.redisClientDelegate.withPipeline(p -> {
            for (String id : identifiers) {
                responses.put(id, p.exists(this.attributesId(type, id)));
            }
            this.redisClientDelegate.syncPipeline(p);
        });
        return responses.entrySet().stream().filter(e -> (Boolean)((Response)e.getValue()).get()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Collection<CacheData> getAll(String type) {
        return this.getAll(type, (CacheFilter)null);
    }

    public Collection<CacheData> getAll(String type, CacheFilter cacheFilter) {
        Set<String> allIds = this.scanMembers(this.allOfTypeId(type));
        return this.getAll(type, allIds, cacheFilter);
    }

    public Collection<CacheData> getAll(String type, String ... identifiers) {
        return this.getAll(type, Arrays.asList(identifiers));
    }

    public Collection<CacheData> getAll(String type, Collection<String> identifiers) {
        return this.getAll(type, identifiers, null);
    }

    public Collection<CacheData> getAll(String type, Collection<String> identifiers, CacheFilter cacheFilter) {
        if (identifiers.isEmpty()) {
            return new ArrayList<CacheData>();
        }
        LinkedHashSet<String> ids = new LinkedHashSet<String>(identifiers);
        Set<String> allRelationships = this.scanMembers(this.allRelationshipsId(type));
        ArrayList<String> knownRels = cacheFilter == null ? new ArrayList<String>(allRelationships) : new ArrayList(cacheFilter.filter(CacheFilter.Type.RELATIONSHIP, allRelationships));
        ArrayList<CacheData> result = new ArrayList<CacheData>(ids.size());
        for (List idPart : Iterables.partition(ids, (int)this.options.getMaxGetBatchSize())) {
            result.addAll(this.getItems(type, idPart, knownRels));
        }
        return result;
    }

    public Collection<String> getIdentifiers(String type) {
        return this.scanMembers(this.allOfTypeId(type));
    }

    public Collection<String> filterIdentifiers(String type, String glob) {
        return this.scanMembers(this.allOfTypeId(type), Optional.of(glob));
    }

    private Set<String> scanMembers(String setKey) {
        return this.scanMembers(setKey, Optional.empty());
    }

    protected Set<String> scanMembers(String setKey, Optional<String> glob) {
        return (Set)this.redisClientDelegate.withCommandsClient(client -> {
            ScanResult scanResult;
            HashSet matches = new HashSet();
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(this.options.getScanSize()));
            glob.ifPresent(arg_0 -> ((ScanParams)scanParams).match(arg_0));
            String cursor = "0";
            do {
                scanResult = client.sscan(setKey, cursor, scanParams);
                matches.addAll(scanResult.getResult());
            } while (!"0".equals(cursor = scanResult.getStringCursor()));
            return matches;
        });
    }

    protected boolean isHashingDisabled(String type) {
        if (!this.options.isHashingEnabled()) {
            return true;
        }
        return (Boolean)this.redisClientDelegate.withCommandsClient(client -> client.exists(this.hashesDisabled(type)));
    }

    protected String attributesId(String type, String id) {
        return String.format("%s:%s:attributes:%s", this.prefix, type, id);
    }

    protected String relationshipId(String type, String id, String relationship) {
        return String.format("%s:%s:relationships:%s:%s", this.prefix, type, id, relationship);
    }

    private String hashesDisabled(String type) {
        return String.format("%s:%s:hashes.disabled", this.prefix, type);
    }

    protected String allRelationshipsId(String type) {
        return String.format("%s:%s:relationships", this.prefix, type);
    }

    protected String allOfTypeId(String type) {
        return String.format("%s:%s:members", this.prefix, type);
    }

    protected String allOfTypeReindex(String type) {
        return String.format("%s:%s:members.2", this.prefix, type);
    }
}

