/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.redis.cache;

import com.google.common.base.Preconditions;

public class RedisCacheOptions {
    private final int maxMsetSize;
    private final int maxMgetSize;
    private final int maxHmgetSize;
    private final int maxHmsetSize;
    private final int maxSaddSize;
    private final int maxDelSize;
    private final int maxPipelineSize;
    private final int scanSize;
    private final int maxMergeBatchSize;
    private final int maxEvictBatchSize;
    private final int maxGetBatchSize;
    private final boolean hashingEnabled;

    public static Builder builder() {
        return new Builder();
    }

    private static int posInt(String name, int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"%s must be a positive integer (%s)", (Object[])new Object[]{name, value});
        return value;
    }

    private static int posEven(String name, int value) {
        Preconditions.checkArgument((value > 0 && value % 2 == 0 ? 1 : 0) != 0, (String)"%s must be a positive even integer (%s)", (Object[])new Object[]{name, value});
        return value;
    }

    public RedisCacheOptions(int maxMsetSize, int maxMgetSize, int maxHmgetSize, int maxHmsetSize, int maxSaddSize, int maxDelSize, int maxPipelineSize, int scanSize, int maxMergeBatchSize, int maxEvictBatchSize, int maxGetBatchSize, boolean hashingEnabled) {
        this.maxMsetSize = RedisCacheOptions.posEven("maxMsetSize", maxMsetSize);
        this.maxMgetSize = RedisCacheOptions.posInt("maxMgetSize", maxMgetSize);
        this.maxHmgetSize = RedisCacheOptions.posInt("maxHmgetSize", maxHmgetSize);
        this.maxHmsetSize = RedisCacheOptions.posInt("maxHmsetSize", maxHmsetSize);
        this.maxSaddSize = RedisCacheOptions.posInt("maxSaddSize", maxSaddSize);
        this.maxDelSize = RedisCacheOptions.posInt("maxDelSize", maxDelSize);
        this.maxPipelineSize = RedisCacheOptions.posInt("maxPipelineSize", maxPipelineSize);
        this.scanSize = RedisCacheOptions.posInt("scanSize", scanSize);
        this.maxMergeBatchSize = RedisCacheOptions.posInt("maxMergeBatchSize", maxMergeBatchSize);
        this.maxEvictBatchSize = RedisCacheOptions.posInt("maxEvictBatchSize", maxEvictBatchSize);
        this.maxGetBatchSize = RedisCacheOptions.posInt("maxGetBatchSize", maxGetBatchSize);
        this.hashingEnabled = hashingEnabled;
    }

    public int getMaxMsetSize() {
        return this.maxMsetSize;
    }

    public int getMaxMgetSize() {
        return this.maxMgetSize;
    }

    public int getMaxHmgetSize() {
        return this.maxHmgetSize;
    }

    public int getMaxHmsetSize() {
        return this.maxHmsetSize;
    }

    public int getMaxSaddSize() {
        return this.maxSaddSize;
    }

    public int getMaxDelSize() {
        return this.maxDelSize;
    }

    public int getMaxPipelineSize() {
        return this.maxPipelineSize;
    }

    public int getScanSize() {
        return this.scanSize;
    }

    public int getMaxMergeBatchSize() {
        return this.maxMergeBatchSize;
    }

    public int getMaxEvictBatchSize() {
        return this.maxEvictBatchSize;
    }

    public int getMaxGetBatchSize() {
        return this.maxGetBatchSize;
    }

    public boolean isHashingEnabled() {
        return this.hashingEnabled;
    }

    public static class Builder {
        public static final int DEFAULT_MULTI_OP_SIZE = 10000;
        public static final int DEFAULT_BATCH_SIZE = 5000;
        public static final int DEFAULT_SCAN_SIZE = 25000;
        public static final int DEFAULT_MAX_PIPELINE_SIZE = 5000;
        public static final boolean DEFAULT_HASHING_ENABLED = true;
        int maxMsetSize;
        int maxMgetSize;
        int maxHmgetSize;
        int maxHmsetSize;
        int maxSaddSize;
        int maxDelSize;
        int maxPipelineSize;
        int scanSize;
        int maxMergeBatchSize;
        int maxEvictBatchSize;
        int maxGetBatchSize;
        boolean hashingEnabled;

        public Builder() {
            this.batchSize(5000);
            this.scan(25000);
            this.multiOp(10000);
            this.maxPipeline(5000);
            this.hashing(true);
        }

        public Builder maxMergeBatch(int maxMergeBatch) {
            this.maxMergeBatchSize = maxMergeBatch;
            return this;
        }

        public Builder maxEvictBatch(int maxEvictBatch) {
            this.maxEvictBatchSize = maxEvictBatch;
            return this;
        }

        public Builder maxGetBatch(int maxGetBatch) {
            this.maxGetBatchSize = maxGetBatch;
            return this;
        }

        public Builder batchSize(int batchSize) {
            return this.maxMergeBatch(batchSize).maxEvictBatch(batchSize).maxGetBatch(batchSize);
        }

        public Builder scan(int scanSize) {
            this.scanSize = scanSize;
            return this;
        }

        public Builder multiOp(int multiOpSize) {
            return this.maxMkeyOp(multiOpSize).maxHmOp(multiOpSize).maxSadd(multiOpSize).maxDel(multiOpSize);
        }

        public Builder maxMset(int maxMset) {
            this.maxMsetSize = maxMset;
            return this;
        }

        public Builder maxMget(int maxMget) {
            this.maxMgetSize = maxMget;
            return this;
        }

        public Builder maxMkeyOp(int maxMkey) {
            return this.maxMset(maxMkey).maxMget(maxMkey);
        }

        public Builder maxHmget(int maxHmget) {
            this.maxHmgetSize = maxHmget;
            return this;
        }

        public Builder maxHmset(int maxHmset) {
            this.maxHmsetSize = maxHmset;
            return this;
        }

        public Builder maxHmOp(int maxHmOp) {
            return this.maxHmget(maxHmOp).maxHmset(maxHmOp);
        }

        public Builder maxSadd(int maxSadd) {
            this.maxSaddSize = maxSadd;
            return this;
        }

        public Builder maxDel(int maxDel) {
            this.maxDelSize = maxDel;
            return this;
        }

        public Builder maxPipeline(int maxPipeline) {
            this.maxPipelineSize = maxPipeline;
            return this;
        }

        public Builder hashing(boolean hashingEnabled) {
            this.hashingEnabled = hashingEnabled;
            return this;
        }

        public RedisCacheOptions build() {
            return new RedisCacheOptions(this.maxMsetSize, this.maxMgetSize, this.maxHmgetSize, this.maxHmsetSize, this.maxSaddSize, this.maxDelSize, this.maxPipelineSize, this.scanSize, this.maxMergeBatchSize, this.maxEvictBatchSize, this.maxGetBatchSize, this.hashingEnabled);
        }

        public void setBatchSize(int batchSize) {
            this.batchSize(batchSize);
        }

        public void setMultiOpSize(int multiOpSize) {
            this.multiOp(multiOpSize);
        }

        public int getMaxMsetSize() {
            return this.maxMsetSize;
        }

        public void setMaxMsetSize(int maxMsetSize) {
            this.maxMsetSize = maxMsetSize;
        }

        public int getMaxMgetSize() {
            return this.maxMgetSize;
        }

        public void setMaxMgetSize(int maxMgetSize) {
            this.maxMgetSize = maxMgetSize;
        }

        public int getMaxHmgetSize() {
            return this.maxHmgetSize;
        }

        public void setMaxHmgetSize(int maxHmgetSize) {
            this.maxHmgetSize = maxHmgetSize;
        }

        public int getMaxHmsetSize() {
            return this.maxHmsetSize;
        }

        public void setMaxHmsetSize(int maxHmsetSize) {
            this.maxHmsetSize = maxHmsetSize;
        }

        public int getMaxSaddSize() {
            return this.maxSaddSize;
        }

        public void setMaxSaddSize(int maxSaddSize) {
            this.maxSaddSize = maxSaddSize;
        }

        public int getMaxDelSize() {
            return this.maxDelSize;
        }

        public void setMaxDelSize(int maxDelSize) {
            this.maxDelSize = maxDelSize;
        }

        public int getMaxPipelineSize() {
            return this.maxPipelineSize;
        }

        public void setMaxPipelineSize(int maxPipelineSize) {
            this.maxPipelineSize = maxPipelineSize;
        }

        public int getScanSize() {
            return this.scanSize;
        }

        public void setScanSize(int scanSize) {
            this.scanSize = scanSize;
        }

        public int getMaxMergeBatchSize() {
            return this.maxMergeBatchSize;
        }

        public void setMaxMergeBatchSize(int maxMergeBatchSize) {
            this.maxMergeBatchSize = maxMergeBatchSize;
        }

        public int getMaxEvictBatchSize() {
            return this.maxEvictBatchSize;
        }

        public void setMaxEvictBatchSize(int maxEvictBatchSize) {
            this.maxEvictBatchSize = maxEvictBatchSize;
        }

        public int getMaxGetBatchSize() {
            return this.maxGetBatchSize;
        }

        public void setMaxGetBatchSize(int maxGetBatchSize) {
            this.maxGetBatchSize = maxGetBatchSize;
        }

        public boolean isHashingEnabled() {
            return this.hashingEnabled;
        }

        public void setHashingEnabled(boolean hashingEnabled) {
            this.hashingEnabled = hashingEnabled;
        }
    }
}

