/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.redis.cluster;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentExecution;
import com.netflix.spinnaker.cats.agent.AgentScheduler;
import com.netflix.spinnaker.cats.agent.AgentSchedulerAware;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.ExecutionInstrumentation;
import com.netflix.spinnaker.cats.module.CatsModuleAware;
import com.netflix.spinnaker.cats.redis.cluster.AgentIntervalProvider;
import com.netflix.spinnaker.cats.redis.cluster.ClusteredSortAgentLock;
import com.netflix.spinnaker.cats.redis.cluster.NodeStatusProvider;
import com.netflix.spinnaker.cats.thread.NamedThreadFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@SuppressFBWarnings
public class ClusteredSortAgentScheduler
extends CatsModuleAware
implements AgentScheduler<ClusteredSortAgentLock>,
Runnable {
    private final JedisPool jedisPool;
    private final NodeStatusProvider nodeStatusProvider;
    private final AgentIntervalProvider intervalProvider;
    private final ExecutorService agentWorkPool;
    private static final int NOW = 0;
    private static final int REDIS_REFRESH_PERIOD = 30;
    private int runCount = 0;
    private final Logger log;
    private Map<String, AgentWorker> agents;
    private Optional<Semaphore> runningAgents;
    private static final String WAITING_SET = "WAITZ";
    private static final String WORKING_SET = "WORKZ";
    private static final String ADD_AGENT_SCRIPT = "addAgentScript";
    private static final String VALID_SCORE_SCRIPT = "validScoreScript";
    private static final String SWAP_SET_SCRIPT = "swapSetScript";
    private static final String REMOVE_AGENT_SCRIPT = "removeAgentScript";
    private static final String CONDITIONAL_SWAP_SET_SCRIPT = "conditionalSwapSetScript";
    private ConcurrentHashMap<String, String> scriptShas;

    public ClusteredSortAgentScheduler(JedisPool jedisPool, NodeStatusProvider nodeStatusProvider, AgentIntervalProvider intervalProvider, Integer parallelism) {
        this.jedisPool = jedisPool;
        this.nodeStatusProvider = nodeStatusProvider;
        this.agents = new ConcurrentHashMap<String, AgentWorker>();
        this.intervalProvider = intervalProvider;
        this.log = LoggerFactory.getLogger(this.getClass());
        if (parallelism == 0 || parallelism < -1) {
            throw new IllegalArgumentException("Argument 'parallelism' must be positive, or -1 (for unlimited parallelism).");
        }
        this.runningAgents = parallelism > 0 ? Optional.of(new Semaphore(parallelism)) : Optional.empty();
        this.scriptShas = new ConcurrentHashMap();
        this.storeScripts();
        this.agentWorkPool = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(AgentWorker.class.getSimpleName()));
        Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(ClusteredSortAgentScheduler.class.getSimpleName())).scheduleAtFixedRate(this, 0L, 1L, TimeUnit.SECONDS);
    }

    private void storeScripts() {
        try (Jedis jedis = this.jedisPool.getResource();){
            this.scriptShas.put(SWAP_SET_SCRIPT, jedis.scriptLoad("local score = redis.call('zscore', KEYS[1], ARGV[1])\nif score ~= nil then\n  redis.call('zrem', KEYS[1], ARGV[1])\n  redis.call('zadd', KEYS[2], ARGV[2], ARGV[1])\n  return score\nelse return nil end\n"));
            this.scriptShas.put(CONDITIONAL_SWAP_SET_SCRIPT, jedis.scriptLoad("local score = redis.call('zscore', KEYS[1], ARGV[1])\nif score == ARGV[3] then\n  redis.call('zrem', KEYS[1], ARGV[1])\n  redis.call('zadd', KEYS[2], ARGV[2], ARGV[1])\n  return score\nelse return nil end\n"));
            this.scriptShas.put(VALID_SCORE_SCRIPT, jedis.scriptLoad("local score = redis.call('zscore', KEYS[1], ARGV[1])\nif score == ARGV[2] then\n  return score\nelse return nil end\n"));
            this.scriptShas.put(ADD_AGENT_SCRIPT, jedis.scriptLoad("if redis.call('zrank', KEYS[1], ARGV[1]) ~= nil then\n  if redis.call('zrank', KEYS[2], ARGV[1]) ~= nil then\n    return redis.call('zadd', KEYS[1], ARGV[2], ARGV[1])\n  else return nil end\nelse return nil end\n"));
            this.scriptShas.put(REMOVE_AGENT_SCRIPT, jedis.scriptLoad("redis.call('zrem', KEYS[1], ARGV[1])\nredis.call('zrem', KEYS[2], ARGV[1])\n"));
        }
    }

    private String getScriptSha(String scriptName, Jedis jedis) {
        String scriptSha = this.scriptShas.get(scriptName);
        if (scriptSha == null) {
            this.storeScripts();
            scriptSha = this.scriptShas.get(scriptName);
            if (scriptSha == null) {
                throw new RuntimeException("Failed to load caching scripts.");
            }
        }
        if (!jedis.scriptExists(scriptSha).booleanValue()) {
            this.storeScripts();
        }
        return this.scriptShas.get(scriptName);
    }

    public void schedule(Agent agent, AgentExecution agentExecution, ExecutionInstrumentation executionInstrumentation) {
        if (agent instanceof AgentSchedulerAware) {
            ((AgentSchedulerAware)agent).setAgentScheduler((AgentScheduler)this);
        }
        if (!(agentExecution instanceof CachingAgent.CacheExecution)) {
            throw new IllegalArgumentException("Sort scheduler requires agent executions to be of type CacheExecution");
        }
        this.agents.put(agent.getAgentType(), new AgentWorker(agent, (CachingAgent.CacheExecution)agentExecution, executionInstrumentation, this));
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.evalsha(this.getScriptSha(ADD_AGENT_SCRIPT, jedis), 2, new String[]{WAITING_SET, WORKING_SET, agent.getAgentType(), ClusteredSortAgentScheduler.score(jedis, 0L)});
        }
    }

    public ClusteredSortAgentLock tryLock(Agent agent) {
        ScoreTuple scores = this.acquireAgent(agent);
        if (scores != null) {
            return new ClusteredSortAgentLock(agent, scores.acquireScore, scores.releaseScore);
        }
        return null;
    }

    public boolean tryRelease(ClusteredSortAgentLock lock) {
        return this.conditionalReleaseAgent(lock.getAgent(), lock.getAcquireScore(), lock.getReleaseScore()) != null;
    }

    public boolean lockValid(ClusteredSortAgentLock lock) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.evalsha(this.getScriptSha(VALID_SCORE_SCRIPT, jedis), 1, new String[]{WORKING_SET, lock.getAgent().getAgentType(), lock.getAcquireScore()}) != null;
            return bl;
        }
    }

    public void unschedule(Agent agent) {
        this.agents.remove(agent.getAgentType());
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.evalsha(this.getScriptSha(REMOVE_AGENT_SCRIPT, jedis), 2, new String[]{WAITING_SET, WORKING_SET, agent.getAgentType()});
        }
    }

    public boolean isAtomic() {
        return true;
    }

    @Override
    public void run() {
        if (!this.nodeStatusProvider.isNodeEnabled()) {
            return;
        }
        try {
            this.saturatePool();
        }
        catch (Throwable t) {
            this.log.error("Failed to run caching agents", t);
        }
        finally {
            ++this.runCount;
        }
    }

    private static String score(Jedis jedis, long offset) {
        List times = jedis.time();
        if (times == null || times.size() != 2) {
            throw new IllegalStateException("Error retrieving time from Redis");
        }
        int time = Integer.parseInt((String)jedis.time().get(0));
        return String.format("%d", (long)time + offset);
    }

    private String agentScore(Agent agent) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Double score = jedis.zscore(WORKING_SET, agent.getAgentType());
            if (score != null) {
                String string = score.toString();
                return string;
            }
            score = jedis.zscore(WAITING_SET, agent.getAgentType());
            if (score != null) {
                String string = score.toString();
                return string;
            }
            String string = null;
            return string;
        }
    }

    private ScoreTuple acquireAgent(Agent agent) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String acquireScore = ClusteredSortAgentScheduler.score(jedis, this.intervalProvider.getInterval(agent).getTimeout());
            Object releaseScore = jedis.evalsha(this.getScriptSha(SWAP_SET_SCRIPT, jedis), Arrays.asList(WAITING_SET, WORKING_SET), Arrays.asList(agent.getAgentType(), acquireScore));
            ScoreTuple scoreTuple = releaseScore != null ? new ScoreTuple(acquireScore, releaseScore.toString()) : null;
            return scoreTuple;
        }
    }

    private ScoreTuple conditionalReleaseAgent(Agent agent, String acquireScore, Status status) {
        try (Jedis jedis = this.jedisPool.getResource();){
            long newInterval = status == Status.SUCCESS ? this.intervalProvider.getInterval(agent).getInterval() : this.intervalProvider.getInterval(agent).getErrorInterval();
            String newAcquireScore = ClusteredSortAgentScheduler.score(jedis, newInterval);
            Object releaseScore = jedis.evalsha(this.getScriptSha(CONDITIONAL_SWAP_SET_SCRIPT, jedis), Arrays.asList(WORKING_SET, WAITING_SET), Arrays.asList(agent.getAgentType(), newAcquireScore, acquireScore));
            ScoreTuple scoreTuple = releaseScore != null ? new ScoreTuple(newAcquireScore, releaseScore.toString()) : null;
            return scoreTuple;
        }
    }

    private ScoreTuple conditionalReleaseAgent(Agent agent, String acquireScore, String newAcquireScore) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String releaseScore = jedis.evalsha(this.getScriptSha(CONDITIONAL_SWAP_SET_SCRIPT, jedis), Arrays.asList(WORKING_SET, WAITING_SET), Arrays.asList(agent.getAgentType(), newAcquireScore, acquireScore)).toString();
            ScoreTuple scoreTuple = releaseScore != null ? new ScoreTuple(newAcquireScore, releaseScore.toString()) : null;
            return scoreTuple;
        }
    }

    private ScoreTuple releaseAgent(Agent agent) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String acquireScore = ClusteredSortAgentScheduler.score(jedis, this.intervalProvider.getInterval(agent).getInterval());
            String releaseScore = jedis.evalsha(this.getScriptSha(SWAP_SET_SCRIPT, jedis), Arrays.asList(WORKING_SET, WAITING_SET), Arrays.asList(agent.getAgentType(), acquireScore)).toString();
            ScoreTuple scoreTuple = releaseScore != null ? new ScoreTuple(acquireScore, releaseScore.toString()) : null;
            return scoreTuple;
        }
    }

    private void saturatePool() {
        try (Jedis jedis = this.jedisPool.getResource();){
            if (this.runCount % 30 == 0) {
                for (String string : this.agents.keySet()) {
                    jedis.evalsha(this.getScriptSha(ADD_AGENT_SCRIPT, jedis), 2, new String[]{WAITING_SET, WORKING_SET, string, ClusteredSortAgentScheduler.score(jedis, 0L)});
                }
            }
            Set oldKeys = jedis.zrangeByScore(WORKING_SET, "-inf", ClusteredSortAgentScheduler.score(jedis, 0L));
            for (String key : oldKeys) {
                AgentWorker worker = this.agents.get(key);
                if (worker == null) continue;
                this.releaseAgent(worker.agent);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(jedis.zrangeByScore(WAITING_SET, "-inf", ClusteredSortAgentScheduler.score(jedis, 0L)));
            HashSet<AgentWorker> workers = new HashSet<AgentWorker>();
            while (!arrayList.isEmpty() && this.runningAgents.map(Semaphore::tryAcquire).orElse(true).booleanValue()) {
                ScoreTuple score;
                String agent = (String)arrayList.remove(0);
                AgentWorker worker = this.agents.get(agent);
                if (worker == null || (score = this.acquireAgent(worker.agent)) == null) continue;
                worker.setScore(score.acquireScore);
                workers.add(worker);
            }
            for (AgentWorker worker : workers) {
                this.agentWorkPool.submit(worker);
            }
        }
    }

    private static class ScoreTuple {
        private final String acquireScore;
        private final String releaseScore;

        public ScoreTuple(String acquireScore, String releaseScore) {
            this.acquireScore = acquireScore;
            this.releaseScore = releaseScore;
        }
    }

    private static class AgentWorker
    implements Runnable {
        private final Agent agent;
        private final CachingAgent.CacheExecution agentExecution;
        private final ExecutionInstrumentation executionInstrumentation;
        private final ClusteredSortAgentScheduler scheduler;
        private String acquireScore;

        AgentWorker(Agent agent, CachingAgent.CacheExecution agentExecution, ExecutionInstrumentation executionInstrumentation, ClusteredSortAgentScheduler scheduler) {
            this.agent = agent;
            this.agentExecution = agentExecution;
            this.executionInstrumentation = executionInstrumentation;
            this.scheduler = scheduler;
        }

        public void setScore(String score) {
            this.acquireScore = score;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (this.acquireScore != null);
            CacheResult result = null;
            Status status = Status.FAILURE;
            try {
                this.executionInstrumentation.executionStarted(this.agent);
                long startTime = System.nanoTime();
                result = this.agentExecution.executeAgentWithoutStore(this.agent);
                this.executionInstrumentation.executionCompleted(this.agent, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
                status = Status.SUCCESS;
            }
            catch (Throwable cause) {
                this.executionInstrumentation.executionFailed(this.agent, cause);
            }
            finally {
                this.scheduler.runningAgents.ifPresent(Semaphore::release);
                if (this.scheduler.conditionalReleaseAgent(this.agent, this.acquireScore, status) != null && result != null) {
                    this.agentExecution.storeAgentResult(this.agent, result);
                }
            }
        }
    }

    private static enum Status {
        SUCCESS,
        FAILURE;

    }
}

