/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.redis.cluster;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentIntervalAware;
import com.netflix.spinnaker.cats.redis.cluster.AgentIntervalProvider;

public class DefaultAgentIntervalProvider
implements AgentIntervalProvider {
    private final long interval;
    private final long errorInterval;
    private final long timeout;

    public DefaultAgentIntervalProvider(long interval) {
        this(interval, interval * 2L);
    }

    public DefaultAgentIntervalProvider(long interval, long timeout) {
        this(interval, interval, timeout);
    }

    public DefaultAgentIntervalProvider(long interval, long errorInterval, long timeout) {
        this.interval = interval;
        this.errorInterval = errorInterval;
        this.timeout = timeout;
    }

    @Override
    public AgentIntervalProvider.Interval getInterval(Agent agent) {
        if (agent instanceof AgentIntervalAware) {
            Long agentInterval = ((AgentIntervalAware)agent).getAgentInterval();
            Long agentErrorInterval = ((AgentIntervalAware)agent).getAgentErrorInterval();
            if (agentInterval != null && agentInterval > 0L) {
                return new AgentIntervalProvider.Interval(agentInterval, agentErrorInterval, 2L * agentInterval);
            }
        }
        return new AgentIntervalProvider.Interval(this.interval, this.errorInterval, this.timeout);
    }

    public long getInterval() {
        return this.interval;
    }

    public long getErrorInterval() {
        return this.errorInterval;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

