/*
 * Copyright 2018 Google, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.netflix.spinnaker.cats.cache;

import com.netflix.spinnaker.kork.annotations.Beta;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Beta
public class CacheIntrospectionStore {
  private static final CacheIntrospectionStore store = new CacheIntrospectionStore();

  private Map<String, AgentIntrospection> agents = new ConcurrentHashMap<>();

  public static CacheIntrospectionStore getStore() {
    return store;
  }

  public Collection<AgentIntrospection> listAgentIntrospections() {
    return agents.values();
  }

  public void recordAgent(AgentIntrospection agentIntrospection) {
    agents.put(agentIntrospection.getId(), agentIntrospection);
  }
}
