/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ArtifactCredentialsRepository {
    private Map<String, List<ArtifactCredentials>> credentialsMap = new ConcurrentHashMap<String, List<ArtifactCredentials>>();

    public void save(ArtifactCredentials credentials) {
        String name = credentials.getName();
        List stored = this.credentialsMap.getOrDefault(name, new ArrayList());
        stored.add(credentials);
        this.credentialsMap.put(credentials.getName(), stored);
    }

    public List<ArtifactCredentials> getAllCredentials() {
        return this.credentialsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

