/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.Yaml;

@Component
public class ArtifactDownloader {
    private final ArtifactCredentialsRepository artifactCredentialsRepository;
    private final ObjectMapper objectMapper;
    final Yaml yamlParser;

    @Autowired
    public ArtifactDownloader(ArtifactCredentialsRepository artifactCredentialsRepository, ObjectMapper objectMapper) {
        this.artifactCredentialsRepository = artifactCredentialsRepository;
        this.objectMapper = objectMapper;
        this.yamlParser = new Yaml();
    }

    public InputStream download(Artifact artifact) throws IOException {
        ArtifactCredentials credentials = this.artifactCredentialsRepository.getAllCredentials().stream().filter(c -> (StringUtils.isEmpty((CharSequence)artifact.getArtifactAccount()) || c.getName().equals(artifact.getArtifactAccount())) && c.handlesType(artifact.getType())).findFirst().orElseThrow(() -> new IllegalArgumentException("No credentials registered to handle " + artifact));
        return credentials.download(artifact);
    }

    public <T> T downloadAsYaml(Artifact artifact, Class<T> clazz) throws IOException {
        InputStream is = this.download(artifact);
        Object parsed = this.yamlParser.load(is);
        return (T)this.objectMapper.convertValue(parsed, clazz);
    }
}

