/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gcs;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactProviderProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"artifacts.gcs.enabled"})
@EnableScheduling
public class GcsArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GcsArtifactConfiguration.class);
    @Autowired
    GcsArtifactProviderProperties gcsArtifactProviderProperties;
    @Autowired
    ArtifactCredentialsRepository artifactCredentialsRepository;

    @Scope(value="prototype")
    @Bean
    @ConfigurationProperties(value="artifacts.gcs")
    GcsArtifactProviderProperties gcsArtifactProviderProperties() {
        return new GcsArtifactProviderProperties();
    }

    @Bean
    List<? extends GcsArtifactCredentials> gcsArtifactCredentials(String clouddriverUserAgentApplicationName) {
        return this.gcsArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                GcsArtifactCredentials c = new GcsArtifactCredentials(clouddriverUserAgentApplicationName, (GcsArtifactAccount)a);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn("Failure instantiating gcs artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

