/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.http.HttpArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(HttpArtifactCredentials.class);
    private final String name;
    @JsonIgnore
    private final Request.Builder requestBuilder;
    @JsonIgnore
    OkHttpClient okHttpClient;

    public HttpArtifactCredentials(HttpArtifactAccount account, OkHttpClient okHttpClient) {
        boolean useAuth;
        this.name = account.getName();
        this.okHttpClient = okHttpClient;
        Request.Builder builder = new Request.Builder();
        boolean useLogin = !StringUtils.isEmpty((CharSequence)account.getUsername()) && !StringUtils.isEmpty((CharSequence)account.getPassword());
        boolean useUsernamePasswordFile = !StringUtils.isEmpty((CharSequence)account.getUsernamePasswordFile());
        boolean bl = useAuth = useLogin || useUsernamePasswordFile;
        if (useAuth) {
            String authHeader = "";
            if (useUsernamePasswordFile) {
                authHeader = "Basic " + Base64.encodeBase64String((byte[])this.credentialsFromFile(account.getUsernamePasswordFile()).getBytes());
            } else if (useLogin) {
                authHeader = "Basic " + Base64.encodeBase64String((byte[])(account.getUsername() + ":" + account.getPassword()).getBytes());
            }
            builder.header("Authorization", authHeader);
            log.info("Loaded credentials for http artifact account {}", (Object)account.getName());
        } else {
            log.info("No credentials included with http artifact account {}", (Object)account.getName());
        }
        this.requestBuilder = builder;
    }

    private String credentialsFromFile(String filename) {
        try {
            String credentials = FileUtils.readFileToString((File)new File(filename));
            return credentials.replace("\n", "");
        }
        catch (IOException e) {
            log.error("Could not read http credentials file {}", (Object)filename);
            return null;
        }
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        Request downloadRequest = this.requestBuilder.url(artifact.getReference()).build();
        Response downloadResponse = this.okHttpClient.newCall(downloadRequest).execute();
        return downloadResponse.body().byteStream();
    }

    @Override
    public boolean handlesType(String type) {
        return type.equals("http/file");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Request.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public HttpArtifactCredentials setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpArtifactCredentials)) {
            return false;
        }
        HttpArtifactCredentials other = (HttpArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Request.Builder this$requestBuilder = this.getRequestBuilder();
        Request.Builder other$requestBuilder = other.getRequestBuilder();
        if (this$requestBuilder == null ? other$requestBuilder != null : !this$requestBuilder.equals(other$requestBuilder)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        return !(this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Request.Builder $requestBuilder = this.getRequestBuilder();
        result = result * 59 + ($requestBuilder == null ? 43 : $requestBuilder.hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        return result;
    }

    public String toString() {
        return "HttpArtifactCredentials(name=" + this.getName() + ", requestBuilder=" + this.getRequestBuilder() + ", okHttpClient=" + this.getOkHttpClient() + ")";
    }
}

