/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.bitbucket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.bitbucket.BitbucketArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.bitbucket.BitbucketArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.bitbucket.BitbucketArtifactProviderProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.bitbucket.enabled"})
@EnableConfigurationProperties(value={BitbucketArtifactProviderProperties.class})
public class BitbucketArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BitbucketArtifactConfiguration.class);
    private final BitbucketArtifactProviderProperties bitbucketArtifactProviderProperties;
    private final ArtifactCredentialsRepository artifactCredentialsRepository;
    private final ObjectMapper objectMapper;

    @Bean
    OkHttpClient bitbucketOkHttpClient() {
        return new OkHttpClient();
    }

    @Bean
    List<? extends BitbucketArtifactCredentials> bitbucketArtifactCredentials(OkHttpClient bitbucketOkHttpClient) {
        return this.bitbucketArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                BitbucketArtifactCredentials c = new BitbucketArtifactCredentials((BitbucketArtifactAccount)a, bitbucketOkHttpClient, this.objectMapper);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (Exception e) {
                log.warn("Failure instantiating Bitbucket artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public BitbucketArtifactConfiguration(BitbucketArtifactProviderProperties bitbucketArtifactProviderProperties, ArtifactCredentialsRepository artifactCredentialsRepository, ObjectMapper objectMapper) {
        this.bitbucketArtifactProviderProperties = bitbucketArtifactProviderProperties;
        this.artifactCredentialsRepository = artifactCredentialsRepository;
        this.objectMapper = objectMapper;
    }
}

