/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.bitbucket;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.bitbucket.BitbucketArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(BitbucketArtifactCredentials.class);
    private final String name;
    private final List<String> types = Arrays.asList("bitbucket/file");
    @JsonIgnore
    private final Request.Builder requestBuilder;
    @JsonIgnore
    OkHttpClient okHttpClient;
    @JsonIgnore
    ObjectMapper objectMapper;

    public BitbucketArtifactCredentials(BitbucketArtifactAccount account, OkHttpClient okHttpClient, ObjectMapper objectMapper) {
        boolean useAuth;
        this.name = account.getName();
        this.okHttpClient = okHttpClient;
        this.objectMapper = objectMapper;
        Request.Builder builder = new Request.Builder();
        boolean useLogin = !StringUtils.isEmpty((CharSequence)account.getUsername()) && !StringUtils.isEmpty((CharSequence)account.getPassword());
        boolean useUsernamePasswordFile = !StringUtils.isEmpty((CharSequence)account.getUsernamePasswordFile());
        boolean bl = useAuth = useLogin || useUsernamePasswordFile;
        if (useAuth) {
            String authHeader = "";
            if (useUsernamePasswordFile) {
                authHeader = Base64.encodeBase64String((byte[])this.credentialsFromFile(account.getUsernamePasswordFile()).getBytes());
            } else if (useLogin) {
                authHeader = Base64.encodeBase64String((byte[])(account.getUsername() + ":" + account.getPassword()).getBytes());
            }
            builder.header("Authorization: Basic ", authHeader);
            log.info("Loaded credentials for Bitbucket artifact account {}", (Object)account.getName());
        } else {
            log.info("No credentials included with Bitbucket artifact account {}", (Object)account.getName());
        }
        this.requestBuilder = builder;
    }

    private String credentialsFromFile(String filename) {
        try {
            String credentials = FileUtils.readFileToString((File)new File(filename));
            return credentials.replace("\n", "");
        }
        catch (IOException e) {
            log.error("Could not read Bitbucket credentials file {}", (Object)filename, (Object)e);
            return null;
        }
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        try {
            HttpUrl.Builder fileUrl = HttpUrl.parse((String)artifact.getReference()).newBuilder();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed Bitbucket content URL in 'reference'. Read more here https://www.spinnaker.io/reference/artifacts/types/bitbucket-file/: " + e.getMessage(), e);
        }
        Request downloadRequest = this.requestBuilder.url(artifact.getReference()).build();
        try {
            Response downloadResponse = this.okHttpClient.newCall(downloadRequest).execute();
            return downloadResponse.body().byteStream();
        }
        catch (IOException e) {
            throw new FailedDownloadException("Unable to download the contents of artifact " + artifact + ": " + e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public Request.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public BitbucketArtifactCredentials setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    public BitbucketArtifactCredentials setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitbucketArtifactCredentials)) {
            return false;
        }
        BitbucketArtifactCredentials other = (BitbucketArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        Request.Builder this$requestBuilder = this.getRequestBuilder();
        Request.Builder other$requestBuilder = other.getRequestBuilder();
        if (this$requestBuilder == null ? other$requestBuilder != null : !this$requestBuilder.equals(other$requestBuilder)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitbucketArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        Request.Builder $requestBuilder = this.getRequestBuilder();
        result = result * 59 + ($requestBuilder == null ? 43 : $requestBuilder.hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    public String toString() {
        return "BitbucketArtifactCredentials(name=" + this.getName() + ", types=" + this.getTypes() + ", requestBuilder=" + this.getRequestBuilder() + ", okHttpClient=" + this.getOkHttpClient() + ", objectMapper=" + this.getObjectMapper() + ")";
    }

    public class FailedDownloadException
    extends IOException {
        public FailedDownloadException(String message) {
            super(message);
        }

        public FailedDownloadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

