/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gcs;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactProviderProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.gcs.enabled"})
@EnableConfigurationProperties(value={GcsArtifactProviderProperties.class})
public class GcsArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GcsArtifactConfiguration.class);
    private final GcsArtifactProviderProperties gcsArtifactProviderProperties;
    private final ArtifactCredentialsRepository artifactCredentialsRepository;

    @Bean
    List<? extends GcsArtifactCredentials> gcsArtifactCredentials(String clouddriverUserAgentApplicationName) {
        return this.gcsArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                GcsArtifactCredentials c = new GcsArtifactCredentials(clouddriverUserAgentApplicationName, (GcsArtifactAccount)a);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn("Failure instantiating gcs artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public GcsArtifactConfiguration(GcsArtifactProviderProperties gcsArtifactProviderProperties, ArtifactCredentialsRepository artifactCredentialsRepository) {
        this.gcsArtifactProviderProperties = gcsArtifactProviderProperties;
        this.artifactCredentialsRepository = artifactCredentialsRepository;
    }
}

