/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.helm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.helm.IndexParser;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelmArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(HelmArtifactCredentials.class);
    private final String name;
    private final List<String> types = Arrays.asList("helm/chart");
    @JsonIgnore
    private final IndexParser indexParser;
    @JsonIgnore
    OkHttpClient okHttpClient;
    @JsonIgnore
    private final Request.Builder requestBuilder;
    @JsonIgnore
    ObjectMapper objectMapper;

    @Override
    public boolean handlesType(String type) {
        return type.equals("helm/chart");
    }

    public HelmArtifactCredentials(HelmArtifactAccount account, OkHttpClient okHttpClient) {
        boolean useAuth;
        this.name = account.getName();
        this.okHttpClient = okHttpClient;
        this.indexParser = new IndexParser(account.getRepository());
        Request.Builder builder = new Request.Builder();
        boolean useLogin = !StringUtils.isEmpty((CharSequence)account.getUsername()) && !StringUtils.isEmpty((CharSequence)account.getPassword());
        boolean useUsernamePasswordFile = !StringUtils.isEmpty((CharSequence)account.getUsernamePasswordFile());
        boolean bl = useAuth = useLogin || useUsernamePasswordFile;
        if (useAuth) {
            String authHeader = "";
            if (useUsernamePasswordFile) {
                authHeader = "Basic " + Base64.encodeBase64String((byte[])this.credentialsFromFile(account.getUsernamePasswordFile()).getBytes());
            } else if (useLogin) {
                authHeader = "Basic " + Base64.encodeBase64String((byte[])(account.getUsername() + ":" + account.getPassword()).getBytes());
            }
            builder.header("Authorization", authHeader);
            log.info("Loaded credentials for helm artifact account {}", (Object)account.getName());
        } else {
            log.info("No credentials included with helm artifact account {}", (Object)account.getName());
        }
        this.requestBuilder = builder;
    }

    private String credentialsFromFile(String filename) {
        try {
            String credentials = FileUtils.readFileToString((File)new File(filename));
            return credentials.trim();
        }
        catch (IOException e) {
            log.error("Could not read helm credentials file {}", (Object)filename, (Object)e);
            return null;
        }
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        InputStream index = this.downloadIndex();
        List<String> urls = this.indexParser.findUrls(index, artifact.getName(), artifact.getVersion());
        for (String url : urls) {
            try {
                Request downloadRequest = this.requestBuilder.url(url).build();
                Response downloadResponse = this.okHttpClient.newCall(downloadRequest).execute();
                return downloadResponse.body().byteStream();
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid url: ", (Object)url);
            }
        }
        throw new FailedDownloadException("Unable to download the contents of artifact");
    }

    @Override
    public List<String> getArtifactNames() {
        List<String> names;
        try {
            InputStream index = this.downloadIndex();
            names = this.indexParser.findNames(index);
        }
        catch (IOException e) {
            throw new NotFoundException("Failed to download chart names for '" + this.name + "' account");
        }
        return names;
    }

    @Override
    public List<String> getArtifactVersions(String artifactName) {
        List<String> versions;
        try {
            InputStream index = this.downloadIndex();
            versions = this.indexParser.findVersions(index, artifactName);
        }
        catch (IOException e) {
            throw new NotFoundException("Failed to download chart versions for '" + this.name + "' account");
        }
        return versions;
    }

    private InputStream downloadIndex() throws IOException {
        Response indexDownloadResponse;
        Request indexDownloadRequest = this.requestBuilder.url(this.indexParser.indexPath()).build();
        try {
            indexDownloadResponse = this.okHttpClient.newCall(indexDownloadRequest).execute();
        }
        catch (IOException e) {
            throw new FailedDownloadException("Failed to download index.yaml file in '" + this.indexParser.getRepository() + "' repository");
        }
        return indexDownloadResponse.body().byteStream();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public IndexParser getIndexParser() {
        return this.indexParser;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public Request.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HelmArtifactCredentials setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    public HelmArtifactCredentials setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmArtifactCredentials)) {
            return false;
        }
        HelmArtifactCredentials other = (HelmArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        IndexParser this$indexParser = this.getIndexParser();
        IndexParser other$indexParser = other.getIndexParser();
        if (this$indexParser == null ? other$indexParser != null : !((Object)this$indexParser).equals(other$indexParser)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        Request.Builder this$requestBuilder = this.getRequestBuilder();
        Request.Builder other$requestBuilder = other.getRequestBuilder();
        if (this$requestBuilder == null ? other$requestBuilder != null : !this$requestBuilder.equals(other$requestBuilder)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HelmArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        IndexParser $indexParser = this.getIndexParser();
        result = result * 59 + ($indexParser == null ? 43 : ((Object)$indexParser).hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        Request.Builder $requestBuilder = this.getRequestBuilder();
        result = result * 59 + ($requestBuilder == null ? 43 : $requestBuilder.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    public String toString() {
        return "HelmArtifactCredentials(name=" + this.getName() + ", types=" + this.getTypes() + ", indexParser=" + this.getIndexParser() + ", okHttpClient=" + this.getOkHttpClient() + ", requestBuilder=" + this.getRequestBuilder() + ", objectMapper=" + this.getObjectMapper() + ")";
    }

    public class FailedDownloadException
    extends IOException {
        public FailedDownloadException(String message) {
            super(message);
        }
    }
}

