/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.http;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.http.HttpArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.http.HttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.http.HttpArtifactProviderProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.http.enabled"})
@EnableConfigurationProperties(value={HttpArtifactProviderProperties.class})
public class HttpArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HttpArtifactConfiguration.class);
    private final HttpArtifactProviderProperties httpArtifactProviderProperties;
    private final ArtifactCredentialsRepository artifactCredentialsRepository;

    @Bean
    OkHttpClient httpOkHttpClient() {
        return new OkHttpClient();
    }

    @Bean
    List<? extends HttpArtifactCredentials> httpArtifactCredentials(OkHttpClient httpOkHttpClient) {
        List result = this.httpArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                HttpArtifactCredentials c = new HttpArtifactCredentials((HttpArtifactAccount)a, httpOkHttpClient);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (Exception e) {
                log.warn("Failure instantiating Http artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.httpArtifactProviderProperties.getAccounts().stream().noneMatch(HttpArtifactAccount::usesAuth)) {
            HttpArtifactAccount noAuthAccount = new HttpArtifactAccount().setName("no-auth-http-account");
            HttpArtifactCredentials noAuthCredentials = new HttpArtifactCredentials(noAuthAccount, httpOkHttpClient);
            result.add(noAuthCredentials);
        }
        return result;
    }

    public HttpArtifactConfiguration(HttpArtifactProviderProperties httpArtifactProviderProperties, ArtifactCredentialsRepository artifactCredentialsRepository) {
        this.httpArtifactProviderProperties = httpArtifactProviderProperties;
        this.artifactCredentialsRepository = artifactCredentialsRepository;
    }
}

