/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.ivy;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactProviderProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.ivy.enabled"})
@EnableConfigurationProperties(value={IvyArtifactProviderProperties.class})
public class IvyArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(IvyArtifactConfiguration.class);
    private final IvyArtifactProviderProperties ivyArtifactProviderProperties;
    private final ArtifactCredentialsRepository artifactCredentialsRepository;

    @Bean
    List<? extends IvyArtifactCredentials> ivyArtifactCredentials() {
        return this.ivyArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                IvyArtifactCredentials c = new IvyArtifactCredentials((IvyArtifactAccount)a);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (Exception e) {
                log.warn("Failure instantiating ivy artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public IvyArtifactConfiguration(IvyArtifactProviderProperties ivyArtifactProviderProperties, ArtifactCredentialsRepository artifactCredentialsRepository) {
        this.ivyArtifactProviderProperties = ivyArtifactProviderProperties;
        this.artifactCredentialsRepository = artifactCredentialsRepository;
    }
}

