/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.ivy;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.DiskFreeingInputStream;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.util.AbstractMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IvyArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(IvyArtifactCredentials.class);
    private final List<String> types = Collections.singletonList("ivy/file");
    private final IvyArtifactAccount account;
    private final Supplier<Path> cacheBuilder;

    public IvyArtifactCredentials(IvyArtifactAccount account) {
        this(account, () -> Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString()));
    }

    public IvyArtifactCredentials(IvyArtifactAccount account, Supplier<Path> cacheBuilder) {
        this.cacheBuilder = cacheBuilder;
        IvyArtifactCredentials.redirectIvyLogsToSlf4j();
        this.account = account;
    }

    private static void redirectIvyLogsToSlf4j() {
        Message.setDefaultLogger((MessageLogger)new AbstractMessageLogger(){
            private final Logger logger = LoggerFactory.getLogger((String)"org.apache.ivy");

            protected void doProgress() {
            }

            protected void doEndProgress(String msg) {
                this.log(msg, 2);
            }

            public void log(String msg, int level) {
                switch (level) {
                    case 0: {
                        this.logger.error(msg);
                        break;
                    }
                    case 1: {
                        this.logger.warn(msg);
                        break;
                    }
                    case 2: {
                        this.logger.info(msg);
                        break;
                    }
                    case 4: {
                        this.logger.debug(msg);
                        break;
                    }
                    case 3: {
                        this.logger.trace(msg);
                    }
                }
            }

            public void rawlog(String msg, int level) {
                this.log(msg, level);
            }
        });
    }

    @Override
    public InputStream download(Artifact artifact) {
        Path cacheDir = this.cacheBuilder.get();
        Ivy ivy = this.account.getSettings().toIvy(cacheDir);
        String[] parts = artifact.getReference().split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Ivy artifact reference must have a group, artifact, and version separated by ':'");
        }
        ModuleRevisionId mrid = new ModuleRevisionId(new ModuleId(parts[0], parts[1]), parts[2]);
        try {
            ResolveReport report = ivy.resolve(mrid, (ResolveOptions)new ResolveOptions().setTransitive(false).setConfs(this.account.getResolveConfigurations().toArray(new String[0])).setLog("download-only"), true);
            return Arrays.stream(report.getAllArtifactsReports()).findFirst().map(rep -> {
                try {
                    return new DiskFreeingInputStream(new FileInputStream(rep.getLocalFile()), cacheDir);
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            }).orElseThrow(() -> new IllegalArgumentException("Unable to resolve artifact for reference '" + artifact.getReference() + "'"));
        }
        catch (IOException | ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getName() {
        return this.account.getName();
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public IvyArtifactAccount getAccount() {
        return this.account;
    }

    public Supplier<Path> getCacheBuilder() {
        return this.cacheBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IvyArtifactCredentials)) {
            return false;
        }
        IvyArtifactCredentials other = (IvyArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        IvyArtifactAccount this$account = this.getAccount();
        IvyArtifactAccount other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        Supplier<Path> this$cacheBuilder = this.getCacheBuilder();
        Supplier<Path> other$cacheBuilder = other.getCacheBuilder();
        return !(this$cacheBuilder == null ? other$cacheBuilder != null : !this$cacheBuilder.equals(other$cacheBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IvyArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        IvyArtifactAccount $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        Supplier<Path> $cacheBuilder = this.getCacheBuilder();
        result = result * 59 + ($cacheBuilder == null ? 43 : $cacheBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "IvyArtifactCredentials(types=" + this.getTypes() + ", account=" + this.getAccount() + ", cacheBuilder=" + this.getCacheBuilder() + ")";
    }
}

