/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.maven;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.maven.MavenArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.maven.MavenArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.maven.MavenArtifactProviderProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.maven.enabled"})
@EnableConfigurationProperties(value={MavenArtifactProviderProperties.class})
public class MavenArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MavenArtifactConfiguration.class);
    private final MavenArtifactProviderProperties mavenArtifactProviderProperties;
    private final ArtifactCredentialsRepository artifactCredentialsRepository;

    @Bean
    List<? extends MavenArtifactCredentials> mavenArtifactCredentials() {
        return this.mavenArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                MavenArtifactCredentials c = new MavenArtifactCredentials((MavenArtifactAccount)a);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (Exception e) {
                log.warn("Failure instantiating maven artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public MavenArtifactConfiguration(MavenArtifactProviderProperties mavenArtifactProviderProperties, ArtifactCredentialsRepository artifactCredentialsRepository) {
        this.mavenArtifactProviderProperties = mavenArtifactProviderProperties;
        this.artifactCredentialsRepository = artifactCredentialsRepository;
    }
}

