/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.maven;

import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.IBiblioResolver;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.IvySettings;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.Resolvers;
import com.netflix.spinnaker.clouddriver.artifacts.maven.MavenArtifactAccount;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArtifactCredentials
extends IvyArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(MavenArtifactCredentials.class);
    private final List<String> types = Collections.singletonList("maven/file");

    public MavenArtifactCredentials(MavenArtifactAccount account) {
        super(MavenArtifactCredentials.toIvyAccount(account));
    }

    public MavenArtifactCredentials(MavenArtifactAccount account, Supplier<Path> cacheBuilder) {
        super(MavenArtifactCredentials.toIvyAccount(account), cacheBuilder);
    }

    private static IvyArtifactAccount toIvyAccount(MavenArtifactAccount maven) {
        IvyArtifactAccount ivy = new IvyArtifactAccount();
        IBiblioResolver mavenResolver = new IBiblioResolver();
        mavenResolver.setName("maven");
        mavenResolver.setM2compatible(true);
        mavenResolver.setUsepoms(true);
        mavenResolver.setUseMavenMetadata(true);
        mavenResolver.setRoot(maven.getRepositoryUrl());
        Resolvers resolvers = new Resolvers();
        resolvers.setIbiblio(Collections.singletonList(mavenResolver));
        IvySettings settings = new IvySettings();
        settings.setResolvers(resolvers);
        ivy.setName(maven.getName());
        ivy.setSettings(settings);
        return ivy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenArtifactCredentials)) {
            return false;
        }
        MavenArtifactCredentials other = (MavenArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MavenArtifactCredentials;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public String toString() {
        return "MavenArtifactCredentials(types=" + this.getTypes() + ")";
    }
}

