/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class S3ArtifactCredentials
implements ArtifactCredentials {
    private final String name;
    private final String apiEndpoint;
    private final String apiRegion;
    private final String region;
    private final String awsAccessKeyId;
    private final String awsSecretAccessKey;
    private final List<String> types = Arrays.asList("s3/object");

    public S3ArtifactCredentials(S3ArtifactAccount account) throws IllegalArgumentException {
        this.name = account.getName();
        this.apiEndpoint = account.getApiEndpoint();
        this.apiRegion = account.getApiRegion();
        this.region = account.getRegion();
        this.awsAccessKeyId = account.getAwsAccessKeyId();
        this.awsSecretAccessKey = account.getAwsSecretAccessKey();
    }

    protected AmazonS3 getS3Client() {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (!StringUtils.isEmpty((CharSequence)this.apiEndpoint)) {
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(this.apiEndpoint, this.apiRegion);
            builder.setEndpointConfiguration(endpoint);
            builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        } else if (!StringUtils.isEmpty((CharSequence)this.region)) {
            builder.setRegion(this.region);
        }
        if (!StringUtils.isEmpty((CharSequence)this.awsAccessKeyId) && !StringUtils.isEmpty((CharSequence)this.awsSecretAccessKey)) {
            BasicAWSCredentials awsStaticCreds = new BasicAWSCredentials(this.awsAccessKeyId, this.awsSecretAccessKey);
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsStaticCreds));
        }
        return (AmazonS3)builder.build();
    }

    @Override
    public InputStream download(Artifact artifact) throws IllegalArgumentException {
        int slash;
        String reference = artifact.getReference();
        if (reference.startsWith("s3://")) {
            reference = reference.substring("s3://".length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("S3 references must be of the format s3://<bucket>/<file-path>, got: " + artifact);
        }
        String bucketName = reference.substring(0, slash);
        String path = reference.substring(slash + 1);
        S3Object s3obj = this.getS3Client().getObject(bucketName, path);
        return s3obj.getObjectContent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public String getApiRegion() {
        return this.apiRegion;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3ArtifactCredentials)) {
            return false;
        }
        S3ArtifactCredentials other = (S3ArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$apiEndpoint = this.getApiEndpoint();
        String other$apiEndpoint = other.getApiEndpoint();
        if (this$apiEndpoint == null ? other$apiEndpoint != null : !this$apiEndpoint.equals(other$apiEndpoint)) {
            return false;
        }
        String this$apiRegion = this.getApiRegion();
        String other$apiRegion = other.getApiRegion();
        if (this$apiRegion == null ? other$apiRegion != null : !this$apiRegion.equals(other$apiRegion)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$awsAccessKeyId = this.getAwsAccessKeyId();
        String other$awsAccessKeyId = other.getAwsAccessKeyId();
        if (this$awsAccessKeyId == null ? other$awsAccessKeyId != null : !this$awsAccessKeyId.equals(other$awsAccessKeyId)) {
            return false;
        }
        String this$awsSecretAccessKey = this.getAwsSecretAccessKey();
        String other$awsSecretAccessKey = other.getAwsSecretAccessKey();
        if (this$awsSecretAccessKey == null ? other$awsSecretAccessKey != null : !this$awsSecretAccessKey.equals(other$awsSecretAccessKey)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    protected boolean canEqual(Object other) {
        return other instanceof S3ArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $apiEndpoint = this.getApiEndpoint();
        result = result * 59 + ($apiEndpoint == null ? 43 : $apiEndpoint.hashCode());
        String $apiRegion = this.getApiRegion();
        result = result * 59 + ($apiRegion == null ? 43 : $apiRegion.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $awsAccessKeyId = this.getAwsAccessKeyId();
        result = result * 59 + ($awsAccessKeyId == null ? 43 : $awsAccessKeyId.hashCode());
        String $awsSecretAccessKey = this.getAwsSecretAccessKey();
        result = result * 59 + ($awsSecretAccessKey == null ? 43 : $awsSecretAccessKey.hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    public String toString() {
        return "S3ArtifactCredentials(name=" + this.getName() + ", apiEndpoint=" + this.getApiEndpoint() + ", apiRegion=" + this.getApiRegion() + ", region=" + this.getRegion() + ", awsAccessKeyId=" + this.getAwsAccessKeyId() + ", awsSecretAccessKey=" + this.getAwsSecretAccessKey() + ", types=" + this.getTypes() + ")";
    }
}

