/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ArtifactCredentialsRepository {
    private final List<ArtifactCredentials> allCredentials;

    public ArtifactCredentialsRepository(List<List<? extends ArtifactCredentials>> allCredentials) {
        this.allCredentials = Collections.unmodifiableList(allCredentials.stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public ArtifactCredentials getCredentials(String accountName) {
        return this.getAllCredentials().stream().filter(e -> e.getName().equals(accountName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No credentials with name '" + accountName + "' could be found."));
    }

    public ArtifactCredentials getCredentials(String accountName, String type) {
        if (StringUtils.isEmpty((CharSequence)accountName)) {
            throw new IllegalArgumentException("An artifact account must be supplied to download this artifact: " + accountName);
        }
        ArtifactCredentials credentials = this.getCredentials(accountName);
        if (!credentials.handlesType(type)) {
            throw new IllegalArgumentException("Artifact credentials '" + accountName + "' cannot handle artifacts of type '" + type + "'");
        }
        return credentials;
    }

    public List<ArtifactCredentials> getAllCredentials() {
        return this.allCredentials;
    }
}

