/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.config;

import com.netflix.spinnaker.clouddriver.artifacts.CredentialReader;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public interface BasicAuth {
    public String getUsername();

    public String getPassword();

    public String getUsernamePasswordFile();

    default public Optional<String> getBasicAuthHeader() {
        String usernamePassword = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getUsernamePasswordFile())) {
            usernamePassword = CredentialReader.credentialsFromFile(this.getUsernamePasswordFile());
        } else if (StringUtils.isNotEmpty((CharSequence)this.getUsername()) && StringUtils.isNotEmpty((CharSequence)this.getPassword())) {
            usernamePassword = this.getUsername() + ":" + this.getPassword();
        }
        return Optional.ofNullable(usernamePassword).map(s -> "Basic " + Base64.encodeBase64String((byte[])s.getBytes()));
    }
}

