/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.config;

import com.netflix.spinnaker.clouddriver.artifacts.CredentialReader;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public interface TokenAuth {
    public String getToken();

    public String getTokenFile();

    default public Optional<String> getTokenAuthHeader() {
        return this.getTokenAsString().map(t -> "token " + t);
    }

    default public Optional<String> getTokenAsString() {
        String token = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getTokenFile())) {
            token = CredentialReader.credentialsFromFile(this.getTokenFile());
        } else if (StringUtils.isNotEmpty((CharSequence)this.getToken())) {
            token = this.getToken();
        }
        return Optional.ofNullable(token);
    }
}

