/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.docker;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.docker.DockerArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(DockerArtifactCredentials.class);
    public static final String TYPE = "docker/image";
    private final String name;
    private final List<String> types = Collections.singletonList("docker/image");

    public DockerArtifactCredentials(DockerArtifactAccount account) {
        this.name = account.getName();
    }

    @Override
    public InputStream download(Artifact artifact) {
        throw new UnsupportedOperationException("Docker references are passed on to cloud platforms who retrieve images directly");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerArtifactCredentials)) {
            return false;
        }
        DockerArtifactCredentials other = (DockerArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    public String toString() {
        return "DockerArtifactCredentials(name=" + this.getName() + ", types=" + this.getTypes() + ")";
    }
}

