/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.embedded;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.embedded.EmbeddedArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedArtifactCredentials.class);
    private final String name;
    private final List<String> types = Collections.singletonList("embedded/base64");
    @JsonIgnore
    private final Base64.Decoder base64Decoder;

    EmbeddedArtifactCredentials(EmbeddedArtifactAccount account) {
        this.name = account.getName();
        this.base64Decoder = Base64.getDecoder();
    }

    @Override
    public InputStream download(Artifact artifact) {
        String type = artifact.getType();
        if (type.equals("embedded/base64")) {
            return this.fromBase64(artifact);
        }
        throw new NotImplementedException("Embedded type '" + type + "' is not handled.");
    }

    private InputStream fromBase64(Artifact artifact) {
        String reference = artifact.getReference();
        return new ByteArrayInputStream(this.base64Decoder.decode(reference));
    }

    @Override
    public boolean handlesType(String type) {
        return type.startsWith("embedded/");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }
}

