/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gcs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(GcsArtifactCredentials.class);
    private final String name;
    private final List<String> types = Collections.singletonList("gcs/object");
    @JsonIgnore
    private final Storage storage;

    GcsArtifactCredentials(String applicationName, GcsArtifactAccount account) throws IOException, GeneralSecurityException {
        GoogleCredential credential;
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        String credentialsPath = account.getJsonPath();
        if (!StringUtils.isEmpty((String)credentialsPath)) {
            FileInputStream stream = new FileInputStream(credentialsPath);
            credential = GoogleCredential.fromStream((InputStream)stream, (HttpTransport)transport, (JsonFactory)jsonFactory).createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.read_only"));
            log.info("Loaded credentials from {}", (Object)credentialsPath);
        } else {
            log.info("artifacts.gcs.enabled without artifacts.gcs.[].jsonPath. Using default application credentials.");
            credential = GoogleCredential.getApplicationDefault();
        }
        this.name = account.getName();
        this.storage = new Storage.Builder((HttpTransport)transport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        int slash;
        String reference = artifact.getReference();
        Long generation = null;
        if (reference.startsWith("gs://")) {
            reference = reference.substring("gs://".length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("GCS references must be of the format gs://<bucket>/<file-path>, got: " + artifact);
        }
        String bucketName = reference.substring(0, slash);
        String path = reference.substring(slash + 1);
        int pound = path.lastIndexOf("#");
        if (pound >= 0) {
            generation = Long.valueOf(path.substring(pound + 1));
            path = path.substring(0, pound);
        }
        Storage.Objects.Get get = this.storage.objects().get(bucketName, path).setGeneration(generation);
        return get.executeMediaAsInputStream();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }
}

