/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.github;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.config.SimpleHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.exceptions.FailedDownloadException;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubArtifactCredentials
extends SimpleHttpArtifactCredentials<GitHubArtifactAccount>
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(GitHubArtifactCredentials.class);
    private final String name;
    private final List<String> types = Collections.singletonList("github/file");
    @JsonIgnore
    private final ObjectMapper objectMapper;

    GitHubArtifactCredentials(GitHubArtifactAccount account, OkHttpClient okHttpClient, ObjectMapper objectMapper) {
        super(okHttpClient, account);
        this.name = account.getName();
        this.objectMapper = objectMapper;
    }

    private HttpUrl getMetadataUrl(Artifact artifact) {
        String version = artifact.getVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            log.info("No version specified for artifact {}, using 'master'.", (Object)version);
            version = "master";
        }
        return this.parseUrl(artifact.getReference()).newBuilder().addQueryParameter("ref", version).build();
    }

    @Override
    protected HttpUrl getDownloadUrl(Artifact artifact) throws IOException {
        ResponseBody metadataResponse;
        try {
            metadataResponse = this.fetchUrl(this.getMetadataUrl(artifact));
        }
        catch (IOException e) {
            throw new FailedDownloadException("Unable to determine the download URL of artifact " + artifact + ": " + e.getMessage(), e);
        }
        ContentMetadata metadata = (ContentMetadata)this.objectMapper.readValue(metadataResponse.string(), ContentMetadata.class);
        if (StringUtils.isEmpty((CharSequence)metadata.downloadUrl)) {
            throw new FailedDownloadException("Failed to retrieve your github artifact's download URL. This is likely due to incorrect auth setup. Artifact: " + artifact);
        }
        return this.parseUrl(metadata.getDownloadUrl());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    static class ContentMetadata {
        @JsonProperty(value="download_url")
        private String downloadUrl;

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public ContentMetadata setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentMetadata)) {
                return false;
            }
            ContentMetadata other = (ContentMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$downloadUrl = this.getDownloadUrl();
            String other$downloadUrl = other.getDownloadUrl();
            return !(this$downloadUrl == null ? other$downloadUrl != null : !this$downloadUrl.equals(other$downloadUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $downloadUrl = this.getDownloadUrl();
            result = result * 59 + ($downloadUrl == null ? 43 : $downloadUrl.hashCode());
            return result;
        }

        public String toString() {
            return "GitHubArtifactCredentials.ContentMetadata(downloadUrl=" + this.getDownloadUrl() + ")";
        }
    }
}

