/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitlab;

import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactProviderProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.gitlab.enabled"})
@EnableConfigurationProperties(value={GitlabArtifactProviderProperties.class})
public class GitlabArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GitlabArtifactConfiguration.class);
    private final GitlabArtifactProviderProperties gitlabArtifactProviderProperties;

    @Bean
    List<? extends GitlabArtifactCredentials> gitlabArtifactCredentials(OkHttpClient okHttpClient) {
        return this.gitlabArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                return new GitlabArtifactCredentials((GitlabArtifactAccount)a, okHttpClient);
            }
            catch (Exception e) {
                log.warn("Failure instantiating Gitlab artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public GitlabArtifactConfiguration(GitlabArtifactProviderProperties gitlabArtifactProviderProperties) {
        this.gitlabArtifactProviderProperties = gitlabArtifactProviderProperties;
    }
}

