/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitlab;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.config.SimpleHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitlabArtifactCredentials
extends SimpleHttpArtifactCredentials<GitlabArtifactAccount>
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(GitlabArtifactCredentials.class);
    private final String name;
    private final List<String> types = Collections.singletonList("gitlab/file");

    GitlabArtifactCredentials(GitlabArtifactAccount account, OkHttpClient okHttpClient) {
        super(okHttpClient, account);
        this.name = account.getName();
    }

    @Override
    protected Headers getHeaders(GitlabArtifactAccount account) {
        Headers.Builder headers = new Headers.Builder();
        Optional<String> token = account.getTokenAsString();
        if (token.isPresent()) {
            headers.set("Private-Token", token.get());
            log.info("Loaded credentials for GitHub Artifact Account {}", (Object)account.getName());
        } else {
            log.info("No credentials included with GitHub Artifact Account {}", (Object)account.getName());
        }
        return headers.build();
    }

    @Override
    protected HttpUrl getDownloadUrl(Artifact artifact) {
        String version = artifact.getVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            log.info("No version specified for artifact {}, using 'master'.", (Object)version);
            version = "master";
        }
        return this.parseUrl(artifact.getReference()).newBuilder().addQueryParameter("ref", version).build();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }
}

