/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.helm;

import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactProviderProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.helm.enabled"})
@EnableConfigurationProperties(value={HelmArtifactProviderProperties.class})
public class HelmArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HelmArtifactConfiguration.class);
    private final HelmArtifactProviderProperties helmArtifactProviderProperties;

    @Bean
    List<? extends HelmArtifactCredentials> helmArtifactCredentials(OkHttpClient okHttpClient) {
        return this.helmArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                return new HelmArtifactCredentials((HelmArtifactAccount)a, okHttpClient);
            }
            catch (Exception e) {
                log.warn("Failure instantiating Helm artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public HelmArtifactConfiguration(HelmArtifactProviderProperties helmArtifactProviderProperties) {
        this.helmArtifactProviderProperties = helmArtifactProviderProperties;
    }
}

