/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.helm;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.netflix.spinnaker.clouddriver.artifacts.helm.EntryConfig;
import com.netflix.spinnaker.clouddriver.artifacts.helm.IndexConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexParser {
    private static final Logger log = LoggerFactory.getLogger(IndexParser.class);
    private String repository;

    public IndexParser(String repository) {
        this.repository = repository;
    }

    public String indexPath() {
        return this.repository + "/index.yaml";
    }

    public List<String> findNames(InputStream in) throws IOException {
        IndexConfig indexConfig = this.buildIndexConfig(in);
        return new ArrayList<String>(indexConfig.getEntries().keySet());
    }

    public List<String> findVersions(InputStream in, String name) throws IOException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Artifact name field should not be empty");
        }
        List<EntryConfig> configs = this.buildEntryConfigsByName(this.buildIndexConfig(in), name);
        ArrayList<String> versions = new ArrayList<String>();
        configs.forEach(e -> versions.add(e.getVersion()));
        return versions;
    }

    public List<String> findUrls(InputStream in, String name, String version) throws IOException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Artifact name field should not be empty");
        }
        List<EntryConfig> configs = this.buildEntryConfigsByName(this.buildIndexConfig(in), name);
        String validVersion = StringUtils.isBlank((CharSequence)version) ? this.findLatestVersion(configs) : version;
        return this.resolveReferenceUrls(this.findUrlsByVersion(configs, validVersion));
    }

    private List<String> resolveReferenceUrls(List<String> urls) {
        return urls.stream().map(this::resolveReferenceUrl).collect(Collectors.toList());
    }

    private String resolveReferenceUrl(String ref) {
        String resolvedRef = ref;
        String base = this.repository;
        if (!base.endsWith("/")) {
            base = base.concat("/");
        }
        try {
            URL baseUrl = new URL(base);
            URL resolvedUrl = new URL(baseUrl, ref);
            resolvedRef = resolvedUrl.toExternalForm();
        }
        catch (MalformedURLException e) {
            log.error("Failed to resolve reference url:" + ref, (Throwable)e);
        }
        return resolvedRef;
    }

    private List<String> findUrlsByVersion(List<EntryConfig> configs, String version) {
        ArrayList<String> urls = new ArrayList<String>();
        configs.forEach(e -> {
            if (e.getVersion().equals(version)) {
                urls.addAll(e.getUrls());
            }
        });
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("Could not find correct entry with artifact version " + version);
        }
        return urls;
    }

    private String findLatestVersion(List<EntryConfig> configs) {
        return configs.stream().max(Comparator.comparing(EntryConfig::getVersion)).get().getVersion();
    }

    private IndexConfig buildIndexConfig(InputStream in) throws IOException {
        IndexConfig indexConfig;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            indexConfig = (IndexConfig)mapper.readValue(in, IndexConfig.class);
        }
        catch (IOException e) {
            throw new IOException("Invalid index.yaml file in repository " + this.repository);
        }
        return indexConfig;
    }

    private List<EntryConfig> buildEntryConfigsByName(IndexConfig indexConfig, String name) {
        List<EntryConfig> configs = indexConfig.getEntries().get(name);
        if (configs == null || configs.isEmpty()) {
            throw new IllegalArgumentException("Could not find correct entry with artifact name " + name);
        }
        return configs;
    }

    public String getRepository() {
        return this.repository;
    }

    public IndexParser setRepository(String repository) {
        this.repository = repository;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexParser)) {
            return false;
        }
        IndexParser other = (IndexParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }

    public String toString() {
        return "IndexParser(repository=" + this.getRepository() + ")";
    }
}

