/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.ivy.settings;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.Pattern;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.Resolver;
import java.util.List;
import javax.annotation.Nullable;

public class SshResolver
extends Resolver<org.apache.ivy.plugins.resolver.SshResolver> {
    @JacksonXmlProperty(isAttribute=true)
    private String user;
    @JacksonXmlProperty(isAttribute=true)
    private String password;
    @JacksonXmlProperty(isAttribute=true)
    @Nullable
    private String host;
    @JacksonXmlProperty(isAttribute=true)
    @Nullable
    private Integer port;
    @JacksonXmlElementWrapper(useWrapping=false)
    @Nullable
    private List<Pattern> ivy;
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<Pattern> artifact;

    @Override
    public org.apache.ivy.plugins.resolver.SshResolver toIvyModel() {
        org.apache.ivy.plugins.resolver.SshResolver sshResolver = new org.apache.ivy.plugins.resolver.SshResolver();
        sshResolver.setHost(this.host);
        if (this.port != null) {
            sshResolver.setPort(this.port.intValue());
        }
        sshResolver.setUser(this.user);
        sshResolver.setUserPassword(this.password);
        if (this.ivy != null) {
            this.ivy.forEach(pattern -> sshResolver.addIvyPattern(pattern.getPattern()));
        }
        this.artifact.forEach(pattern -> sshResolver.addArtifactPattern(pattern.getPattern()));
        return super.toIvyModel(sshResolver);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshResolver)) {
            return false;
        }
        SshResolver other = (SshResolver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        List<Pattern> this$ivy = this.getIvy();
        List<Pattern> other$ivy = other.getIvy();
        if (this$ivy == null ? other$ivy != null : !((Object)this$ivy).equals(other$ivy)) {
            return false;
        }
        List<Pattern> this$artifact = this.getArtifact();
        List<Pattern> other$artifact = other.getArtifact();
        return !(this$artifact == null ? other$artifact != null : !((Object)this$artifact).equals(other$artifact));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SshResolver;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        List<Pattern> $ivy = this.getIvy();
        result = result * 59 + ($ivy == null ? 43 : ((Object)$ivy).hashCode());
        List<Pattern> $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : ((Object)$artifact).hashCode());
        return result;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public List<Pattern> getIvy() {
        return this.ivy;
    }

    public List<Pattern> getArtifact() {
        return this.artifact;
    }

    public SshResolver setUser(String user) {
        this.user = user;
        return this;
    }

    public SshResolver setPassword(String password) {
        this.password = password;
        return this;
    }

    public SshResolver setHost(@Nullable String host) {
        this.host = host;
        return this;
    }

    public SshResolver setPort(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    public SshResolver setIvy(@Nullable List<Pattern> ivy) {
        this.ivy = ivy;
        return this;
    }

    public SshResolver setArtifact(List<Pattern> artifact) {
        this.artifact = artifact;
        return this;
    }

    @Override
    public String toString() {
        return "SshResolver(user=" + this.getUser() + ", password=" + this.getPassword() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", ivy=" + this.getIvy() + ", artifact=" + this.getArtifact() + ")";
    }
}

